/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class PullRequestParticipantSearchRequest {
    private final String filter;
    private final Repository fromRepository;
    private final PullRequestRole role;
    private final Repository toRepository;

    private PullRequestParticipantSearchRequest(Builder builder) {
        this.fromRepository = builder.fromRepository;
        this.role = builder.role;
        this.filter = builder.filter;
        this.toRepository = builder.toRepository;
    }

    @Nonnull
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    @Nonnull
    public Optional<Repository> getFromRepository() {
        return Optional.ofNullable(this.fromRepository);
    }

    @Nonnull
    public Optional<PullRequestRole> getRole() {
        return Optional.ofNullable(this.role);
    }

    @Nonnull
    public Optional<Repository> getToRepository() {
        return Optional.ofNullable(this.toRepository);
    }

    public static class Builder {
        private String filter;
        private Repository fromRepository;
        private PullRequestRole role;
        private Repository toRepository;

        @Nonnull
        public PullRequestParticipantSearchRequest build() {
            return new PullRequestParticipantSearchRequest(this);
        }

        @Nonnull
        public Builder filter(@Nullable String value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public Builder fromRepository(@Nullable Repository value) {
            this.fromRepository = value;
            return this;
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            this.role = value;
            return this;
        }

        @Nonnull
        public Builder toRepository(@Nullable Repository value) {
            this.toRepository = value;
            return this;
        }
    }
}

