/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class PullRequestParticipantStatusRequest
extends AbstractPullRequestRequest {
    private final String lastReviewedCommit;
    private final PullRequestParticipantStatus status;

    private PullRequestParticipantStatusRequest(Builder builder) {
        super(builder);
        this.lastReviewedCommit = builder.lastReviewedCommit;
        this.status = Objects.requireNonNull(builder.status, "status");
    }

    @Nullable
    public String getLastReviewedCommit() {
        return this.lastReviewedCommit;
    }

    @Nonnull
    public PullRequestParticipantStatus getStatus() {
        return this.status;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private String lastReviewedCommit;
        private PullRequestParticipantStatus status;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestParticipantStatusRequest build() {
            return new PullRequestParticipantStatusRequest(this);
        }

        @Nonnull
        public Builder lastReviewedCommit(@Nullable String value) {
            this.lastReviewedCommit = value;
            return this.self();
        }

        @Nonnull
        public Builder status(@Nonnull PullRequestParticipantStatus value) {
            this.status = Objects.requireNonNull(value, "status");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

