/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PullRequestSearchRequest {
    public static final int MAXIMUM_BRANCHES_TO_SEARCH = 100;
    private final Date closedSince;
    private final Boolean draft;
    private final String filterText;
    private final Collection<String> fromRefIds;
    private final Integer fromRepositoryId;
    private final List<PullRequestOrder> orders;
    private final Collection<PullRequestParticipantRequest> participants;
    private final PullRequestState state;
    private final Collection<String> toRefIds;
    private final Integer toRepositoryId;
    private final Date updatedSince;
    private final boolean withDescription;
    private final boolean withProperties;

    private PullRequestSearchRequest(Builder builder) {
        this.closedSince = builder.closedSince;
        this.draft = builder.draft;
        this.filterText = builder.filterText;
        this.fromRefIds = builder.fromRefIds.build();
        this.fromRepositoryId = builder.fromRepositoryId;
        this.orders = builder.orders.build();
        this.participants = builder.participants.build();
        this.state = builder.state;
        this.toRefIds = builder.toRefIds.build();
        this.toRepositoryId = builder.toRepositoryId;
        this.updatedSince = builder.updatedSince;
        this.withDescription = builder.withDescription;
        this.withProperties = builder.withProperties;
        if (this.fromRefIds.size() + this.toRefIds.size() > 100) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not allow searching more than 100 branches");
        }
    }

    @Nullable
    public Date getClosedSince() {
        return this.closedSince;
    }

    @Nullable
    public String getFilterText() {
        return this.filterText;
    }

    @Nonnull
    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    @Nullable
    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    @Nonnull
    public List<PullRequestOrder> getOrders() {
        return this.orders;
    }

    @Nonnull
    public Collection<PullRequestParticipantRequest> getParticipants() {
        return this.participants;
    }

    @Nullable
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    @Nullable
    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    @Nullable
    public Date getUpdatedSince() {
        return this.updatedSince;
    }

    @Nullable
    public Boolean isDraft() {
        return this.draft;
    }

    public boolean isWithDescription() {
        return this.withDescription;
    }

    public boolean isWithProperties() {
        return this.withProperties;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> fromRefIds = ImmutableSet.builder();
        private final ImmutableList.Builder<PullRequestOrder> orders = ImmutableList.builder();
        private final ImmutableList.Builder<PullRequestParticipantRequest> participants = ImmutableList.builder();
        private final ImmutableSet.Builder<String> toRefIds = ImmutableSet.builder();
        private Date closedSince;
        private Boolean draft;
        private String filterText;
        private Integer fromRepositoryId;
        private PullRequestState state;
        private Integer toRepositoryId;
        private Date updatedSince;
        private boolean withDescription = true;
        private boolean withProperties = true;

        @Nonnull
        public PullRequestSearchRequest build() {
            return new PullRequestSearchRequest(this);
        }

        @Nonnull
        public Builder closedSince(@Nullable Date value) {
            this.closedSince = value;
            return this;
        }

        @Nonnull
        public Builder draft(@Nullable Boolean value) {
            this.draft = value;
            return this;
        }

        @Nonnull
        public Builder repositoryAndBranch(@Nullable PullRequestDirection direction, @Nullable Integer repositoryId, @Nullable String branch) {
            if (direction == PullRequestDirection.OUTGOING) {
                Builder.addIf(NOT_BLANK, this.fromRefIds, branch);
                if (this.fromRepositoryId != null && !this.fromRepositoryId.equals(repositoryId)) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.fromRepositoryId = repositoryId;
            } else {
                Builder.addIf(NOT_BLANK, this.toRefIds, branch);
                if (this.toRepositoryId != null && !this.toRepositoryId.equals(repositoryId)) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.toRepositoryId = repositoryId;
            }
            return this;
        }

        @Nonnull
        public Builder filterText(@Nullable String value) {
            this.filterText = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder fromRepositoryId(@Nullable Integer value) {
            this.fromRepositoryId = value;
            return this;
        }

        @Nonnull
        public Builder fromRefId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, value);
            return this;
        }

        @Nonnull
        public Builder fromRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, values);
            return this;
        }

        @Nonnull
        public Builder order(@Nullable PullRequestOrder value) {
            Builder.addIf(Objects::nonNull, this.orders, value);
            return this;
        }

        @Nonnull
        public Builder orders(@Nullable PullRequestOrder value, PullRequestOrder ... values) {
            Builder.addIf(Objects::nonNull, this.orders, value, values);
            return this;
        }

        @Nonnull
        public Builder orders(@Nullable Iterable<PullRequestOrder> values) {
            Builder.addIf(Objects::nonNull, this.orders, values);
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipantRequest value) {
            Builder.addIf(Objects::nonNull, this.participants, value);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipantRequest> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer value) {
            this.toRepositoryId = value;
            return this;
        }

        @Nonnull
        public Builder toRefId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.toRefIds, value);
            return this;
        }

        @Nonnull
        public Builder toRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.toRefIds, values);
            return this;
        }

        @Nonnull
        public Builder updatedSince(@Nullable Date value) {
            this.updatedSince = value;
            return this;
        }

        @Nonnull
        public Builder withDescription(boolean value) {
            this.withDescription = value;
            return this;
        }

        @Nonnull
        public Builder withProperties(boolean value) {
            this.withProperties = value;
            return this;
        }
    }
}

