/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.AbstractPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SetPullRequestMergeConfigRequest
extends AbstractPullRequestMergeConfigRequest {
    private final PullRequestCommitMessageTemplate commitMessageTemplate;
    private final int commitSummaries;
    private final String defaultStrategyId;
    private final Set<String> enabledStrategyIds;
    private final boolean updateCommitMessageTemplate;

    private SetPullRequestMergeConfigRequest(Builder builder) {
        super(builder);
        this.commitSummaries = Math.max(builder.commitSummaries, 0);
        this.defaultStrategyId = builder.defaultStrategyId;
        this.enabledStrategyIds = builder.enabledStrategyIds.build();
        this.updateCommitMessageTemplate = builder.updateCommitMessageTemplate;
        this.commitMessageTemplate = builder.commitMessageTemplate;
    }

    @Nonnull
    public Optional<PullRequestCommitMessageTemplate> getCommitMessageTemplate() {
        return Optional.ofNullable(this.commitMessageTemplate);
    }

    public int getCommitSummaries() {
        return this.commitSummaries;
    }

    @Nonnull
    public String getDefaultStrategyId() {
        return this.defaultStrategyId;
    }

    @Nonnull
    public Set<String> getEnabledStrategyIds() {
        return this.enabledStrategyIds;
    }

    public boolean isUpdateCommitMessageTemplate() {
        return this.updateCommitMessageTemplate;
    }

    public static class Builder
    extends AbstractPullRequestMergeConfigRequest.AbstractBuilder<Builder, SetPullRequestMergeConfigRequest> {
        private final ImmutableSet.Builder<String> enabledStrategyIds = ImmutableSet.builder();
        private PullRequestCommitMessageTemplate commitMessageTemplate;
        private int commitSummaries = 20;
        private String defaultStrategyId;
        private boolean updateCommitMessageTemplate = false;

        public Builder(@Nonnull Project project, @Nonnull String scmId) {
            super(project, scmId);
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull String scmId) {
            super(scmId);
        }

        @Override
        @Nonnull
        public SetPullRequestMergeConfigRequest build() {
            if (this.defaultStrategyId == null) {
                throw new IllegalStateException("The default strategy ID is required.");
            }
            return new SetPullRequestMergeConfigRequest(this);
        }

        public Builder commitMessageTemplate(@Nullable PullRequestCommitMessageTemplate value) {
            this.updateCommitMessageTemplate = true;
            this.commitMessageTemplate = value;
            return this;
        }

        @Nonnull
        public Builder commitSummaries(int value) {
            this.commitSummaries = value;
            return this.self();
        }

        @Nonnull
        public Builder defaultStrategyId(@Nonnull String value) {
            this.defaultStrategyId = Builder.requireNonBlank(value, "defaultStrategyId");
            return this.self();
        }

        @Nonnull
        public Builder enabledStrategyId(@Nonnull String value) {
            this.enabledStrategyIds.add((Object)Builder.requireNonBlank(value, "enabledStrategyId"));
            return this.self();
        }

        @Nonnull
        public Builder enabledStrategyIds(@Nonnull Iterable<String> values) {
            Objects.requireNonNull(values, "enabledStrategyIds");
            values.forEach(this::enabledStrategyId);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

