/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull.reviewer;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class ReviewerGroupCreateRequest {
    private final String description;
    private final String name;
    private final Scope scope;
    private final Set<ApplicationUser> users;

    private ReviewerGroupCreateRequest(Builder builder) {
        this.description = builder.description;
        this.name = builder.name;
        this.scope = builder.scope;
        this.users = builder.users.build();
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nonnull
    public Set<ApplicationUser> getUsers() {
        return this.users;
    }

    public static class Builder
    extends BuilderSupport {
        private final String name;
        private final Scope scope;
        private final ImmutableSet.Builder<ApplicationUser> users;
        private String description;

        public Builder(@Nonnull String name, @Nonnull Scope scope) {
            this.name = Builder.requireNonBlank(name, "name");
            this.scope = Objects.requireNonNull(scope, "scope");
            this.users = ImmutableSet.builder();
        }

        @Nonnull
        public ReviewerGroupCreateRequest build() {
            return new ReviewerGroupCreateRequest(this);
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public Builder users(ApplicationUser ... values) {
            this.users.addAll(Arrays.asList(values));
            return this;
        }

        @Nonnull
        public Builder users(@Nonnull Iterable<ApplicationUser> values) {
            Builder.addIf(Objects::nonNull, this.users, values);
            return this;
        }
    }
}

