/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull.reviewer;

import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class ReviewerGroupUpdateRequest {
    private final String description;
    private final long id;
    private final String name;
    private final Set<ApplicationUser> users;

    private ReviewerGroupUpdateRequest(Builder builder) {
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.users = builder.users.build();
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<ApplicationUser> getUsers() {
        return this.users;
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private final ImmutableSet.Builder<ApplicationUser> users;
        private String description;
        private String name;

        public Builder(ReviewerGroup reviewerGroup) {
            this.id = reviewerGroup.getId();
            this.description = reviewerGroup.getDescription();
            this.name = reviewerGroup.getName();
            this.users = ImmutableSet.builder();
        }

        @Nonnull
        public ReviewerGroupUpdateRequest build() {
            return new ReviewerGroupUpdateRequest(this);
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Builder.requireNonBlank(value, "name");
            return this;
        }

        @Nonnull
        public Builder users(ApplicationUser ... values) {
            this.users.addAll(Arrays.asList(values));
            return this;
        }

        @Nonnull
        public Builder users(@Nonnull Iterable<ApplicationUser> values) {
            Builder.addIf(Objects::nonNull, this.users, values);
            return this;
        }
    }
}

