/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public abstract class AbstractRepositoryRequest {
    private final String description;
    private final boolean forkable;
    private final String name;
    private final boolean publiclyAccessible;

    protected AbstractRepositoryRequest(AbstractBuilder builder) {
        this.description = builder.description;
        this.forkable = builder.forkable;
        this.name = builder.name;
        this.publiclyAccessible = builder.publiclyAccessible;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isForkable() {
        return this.forkable;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends BuilderSupport {
        private String description;
        private boolean forkable;
        private String name;
        private boolean publiclyAccessible;

        protected AbstractBuilder() {
            this.forkable = true;
        }

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.description = Objects.requireNonNull(repository, "repository").getDescription();
            this.forkable = repository.isForkable();
            this.name = repository.getName();
            this.publiclyAccessible = repository.isPublic();
        }

        protected AbstractBuilder(@Nonnull AbstractRepositoryRequest request) {
            this.description = Objects.requireNonNull(request, "request").getDescription();
            this.forkable = request.isForkable();
            this.name = request.getName();
            this.publiclyAccessible = request.isPublic();
        }

        @Nonnull
        public B description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        @Nonnull
        public B forkable(boolean value) {
            this.forkable = value;
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            this.name = AbstractBuilder.checkNotBlank(value, "name");
            return this.self();
        }

        @Nonnull
        public B publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this.self();
        }

        protected abstract B self();
    }
}

