/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RepositorySearchRequest {
    private final RepositoryArchiveFilter archived;
    private final String name;
    private final Permission permission;
    private final String projectName;
    private final String projectKey;
    private final Repository.State state;
    private final RepositoryVisibility visibility;

    private RepositorySearchRequest(String name, String projectName, String projectKey, Permission permission, RepositoryVisibility visibility, Repository.State state, RepositoryArchiveFilter archived) {
        this.archived = archived;
        this.name = name;
        this.permission = permission;
        this.projectName = projectName;
        this.projectKey = projectKey;
        this.state = state;
        this.visibility = visibility;
    }

    @Nullable
    public RepositoryArchiveFilter getArchived() {
        return this.archived;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public Repository.State getState() {
        return this.state;
    }

    @Nullable
    public Permission getPermission() {
        return this.permission;
    }

    @Nullable
    public RepositoryVisibility getVisibility() {
        return this.visibility;
    }

    public boolean hasArchived() {
        return this.archived != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasProjectName() {
        return this.projectName != null;
    }

    public boolean hasProjectKey() {
        return this.projectKey != null;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    public boolean isEmpty() {
        return !this.hasName() && !this.hasProjectName() && !this.hasPermission() && !this.hasState() && !this.hasVisibility();
    }

    public static class Builder {
        private RepositoryArchiveFilter archived = RepositoryArchiveFilter.ACTIVE;
        private String name;
        private String projectName;
        private String projectKey;
        private Permission permission;
        private Repository.State state;
        private RepositoryVisibility visibility;

        public Builder() {
        }

        public Builder(@Nonnull RepositorySearchRequest request) {
            this.archived = request.getArchived();
            this.name = Objects.requireNonNull(request, "request").getName();
            this.permission = request.getPermission();
            this.projectKey = request.getProjectKey();
            this.state = request.getState();
            this.visibility = request.getVisibility();
        }

        @Nonnull
        public RepositorySearchRequest build() {
            return new RepositorySearchRequest(this.name, this.projectName, this.projectKey, this.permission, this.visibility, this.state, this.archived);
        }

        @Nonnull
        public Builder archived(@Nullable RepositoryArchiveFilter value) {
            this.archived = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder projectName(@Nullable String value) {
            this.projectName = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder projectKey(@Nullable String value) {
            this.projectKey = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder permission(@Nullable Permission value) {
            Preconditions.checkArgument((value == null || value.isResource(Repository.class) ? 1 : 0) != 0, (Object)"The provided permission is not valid for repositories");
            this.permission = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nullable Repository.State value) {
            Preconditions.checkArgument((value != Repository.State.OFFLINE ? 1 : 0) != 0, (Object)"Searching for offline repositories is not supported.");
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder visibility(@Nullable RepositoryVisibility value) {
            this.visibility = value;
            return this;
        }
    }
}

