/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RepositoryUpdateRequest
extends AbstractRepositoryRequest {
    private final Boolean archived;
    private final String defaultBranch;
    private final int id;
    private final Project project;

    private RepositoryUpdateRequest(Builder builder) {
        super(builder);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.getName()));
        this.archived = builder.archived;
        this.defaultBranch = builder.defaultBranch;
        this.id = builder.id;
        this.project = builder.project;
    }

    @Nullable
    public Boolean getArchived() {
        return this.archived;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public Project getProject() {
        return this.project;
    }

    public static class Builder
    extends AbstractRepositoryRequest.AbstractBuilder<Builder> {
        private Boolean archived;
        private String defaultBranch;
        private int id;
        private Project project;

        public Builder() {
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
            this.archived = repository.isArchived();
            this.id = repository.getId();
        }

        public Builder(@Nonnull RepositoryUpdateRequest request) {
            super(request);
            this.archived = request.getArchived();
            this.defaultBranch = request.getDefaultBranch();
            this.id = request.getId();
            this.project = request.getProject();
        }

        @Nonnull
        public RepositoryUpdateRequest build() {
            return new RepositoryUpdateRequest(this);
        }

        @Nonnull
        public Builder archived(boolean value) {
            this.archived = value;
            return this.self();
        }

        @Nonnull
        public Builder defaultBranch(@Nullable String value) {
            this.defaultBranch = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder id(int value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder project(@Nullable Project value) {
            this.project = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

