/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class ResolveRefRequest {
    private final String refId;
    private final Repository repository;
    private final RefType type;

    private ResolveRefRequest(Builder builder) {
        this.refId = builder.refId;
        this.repository = builder.repository;
        this.type = builder.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveRefRequest that = (ResolveRefRequest)o;
        return Objects.equals(this.refId, that.refId) && Objects.equals(this.repository, that.repository) && Objects.equals(this.type, that.type);
    }

    @Nonnull
    public Optional<String> getRefId() {
        return Optional.ofNullable(this.refId);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Optional<RefType> getType() {
        return Optional.ofNullable(this.type);
    }

    public int hashCode() {
        return Objects.hash(this.refId, this.repository, this.type);
    }

    public static class Builder
    extends BuilderSupport {
        private final Repository repository;
        private String refId;
        private RefType type;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public ResolveRefRequest build() {
            return new ResolveRefRequest(this);
        }

        @Nonnull
        public Builder refId(@Nullable String value) {
            this.refId = value;
            return this;
        }

        @Nonnull
        public Builder type(@Nullable RefType value) {
            this.type = value;
            return this;
        }
    }
}

