/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class ResolveRefsRequest {
    private final Set<String> branchIds;
    private final Set<String> refIds;
    private final Repository repository;
    private final Set<String> tagIds;

    private ResolveRefsRequest(Builder builder) {
        this.branchIds = builder.branchIds.build();
        this.refIds = builder.refIds.build();
        this.repository = builder.repository;
        this.tagIds = builder.tagIds.build();
    }

    @Nonnull
    public Set<String> getBranchIds() {
        return this.branchIds;
    }

    @Nonnull
    public Set<String> getRefIds() {
        return this.refIds;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> branchIds;
        private final ImmutableSet.Builder<String> refIds;
        private final Repository repository;
        private final ImmutableSet.Builder<String> tagIds;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.branchIds = ImmutableSet.builder();
            this.refIds = ImmutableSet.builder();
            this.tagIds = ImmutableSet.builder();
        }

        @Nonnull
        public Builder branchId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.branchIds, value);
            return this;
        }

        @Nonnull
        public Builder branchIds(@Nullable String value, String ... moreValues) {
            Builder.addIf(NOT_BLANK, this.branchIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder branchIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.branchIds, values);
            return this;
        }

        @Nonnull
        public ResolveRefsRequest build() {
            return new ResolveRefsRequest(this);
        }

        @Nonnull
        public Builder refId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.refIds, value);
            return this;
        }

        @Nonnull
        public Builder refIds(@Nullable String value, String ... moreValues) {
            Builder.addIf(NOT_BLANK, this.refIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder refIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.refIds, values);
            return this;
        }

        @Nonnull
        public Builder tagId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.tagIds, value);
            return this;
        }

        @Nonnull
        public Builder tagIds(@Nullable String value, String ... moreValues) {
            Builder.addIf(NOT_BLANK, this.tagIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder tagIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.tagIds, values);
            return this;
        }
    }
}

