/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleMinimalRef
implements MinimalRef {
    private final String displayId;
    private final String id;
    private final RefType type;

    protected SimpleMinimalRef(@Nonnull AbstractMinimalRefBuilder<?, ?> builder, @Nonnull RefType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.displayId = Objects.requireNonNull(Objects.requireNonNull(builder, (String)"builder").displayId, "displayId");
        this.id = (String)MoreObjects.firstNonNull((Object)builder.id, (Object)builder.displayId);
    }

    @Override
    @Nonnull
    public String getDisplayId() {
        return this.displayId;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public RefType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass().equals(o.getClass())) {
            SimpleMinimalRef that = (SimpleMinimalRef)o;
            return this.id.equals(that.id);
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.fieldsToString()).toString();
    }

    @Nonnull
    protected String fieldsToString() {
        return "id=" + this.getId() + ", displayId=" + this.getDisplayId();
    }

    protected static abstract class AbstractMinimalRefBuilder<B extends AbstractMinimalRefBuilder<B, R>, R extends MinimalRef> {
        private String displayId;
        private String id;

        protected AbstractMinimalRefBuilder() {
        }

        protected AbstractMinimalRefBuilder(@Nonnull R ref) {
            this.displayId = ((MinimalRef)Objects.requireNonNull(ref, "ref")).getDisplayId();
            this.id = ref.getId();
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B displayId(@Nullable String value) {
            this.displayId = value;
            return this.self();
        }

        @Nonnull
        public B id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }

    public static class Builder
    extends AbstractMinimalRefBuilder<Builder, MinimalRef> {
        private RefType type;

        public Builder() {
        }

        public Builder(@Nonnull MinimalRef ref) {
            super(ref);
            this.type = ref.getType();
        }

        @Override
        @Nonnull
        public SimpleMinimalRef build() {
            return new SimpleMinimalRef(this, this.type);
        }

        @Nonnull
        public Builder type(@Nonnull RefType value) {
            this.type = Objects.requireNonNull(value, "type");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

