/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.SimpleMinimalRefChange;
import com.atlassian.bitbucket.repository.Tag;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleRefChange
extends SimpleMinimalRefChange
implements RefChange {
    private final String fromHash;
    private final String toHash;

    protected SimpleRefChange(@Nonnull AbstractBuilder<?> builder) {
        super(builder);
        this.fromHash = Objects.requireNonNull(builder.fromHash, "fromHash");
        this.toHash = Objects.requireNonNull(builder.toHash, "toHash");
    }

    @Override
    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Override
    @Nonnull
    public MinimalRef getRef() {
        return super.getRef();
    }

    @Override
    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Override
    @Nonnull
    public RefChangeType getType() {
        return super.getType();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleRefChange that = (SimpleRefChange)o;
        return this.fromHash.equals(that.fromHash) && this.toHash.equals(that.toHash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fromHash, this.toHash);
    }

    @Override
    public String toString() {
        return this.getRef().getId() + ": " + this.getFromHash() + " -> " + this.getToHash() + " (" + String.valueOf((Object)this.getType()) + ")";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends SimpleMinimalRefChange.AbstractMinimalRefChangeBuilder<B, RefChange> {
        private String fromHash;
        private String toHash;

        protected AbstractBuilder() {
        }

        public AbstractBuilder(@Nonnull RefChange change) {
            super(change);
            this.fromHash = Objects.requireNonNull(change, "change").getFromHash();
            this.toHash = change.getToHash();
        }

        @Nonnull
        public B from(@Nonnull Ref value) {
            this.fromHash = Objects.requireNonNull(value, "ref").getLatestCommit();
            return (B)this.ref(value);
        }

        @Nonnull
        public B fromHash(@Nonnull String value) {
            this.fromHash = Objects.requireNonNull(value, "value");
            return (B)this.self();
        }

        @Override
        @Nonnull
        public B ref(@Nonnull MinimalRef value) {
            return (B)((AbstractBuilder)super.ref(value));
        }

        @Nonnull
        public B to(@Nonnull Ref value) {
            Objects.requireNonNull(value, "ref");
            if (value instanceof Tag) {
                Tag tag = (Tag)value;
                this.toHash = (String)MoreObjects.firstNonNull((Object)tag.getHash(), (Object)tag.getLatestCommit());
            } else {
                this.toHash = value.getLatestCommit();
            }
            return (B)this.ref(value);
        }

        @Nonnull
        public B toHash(@Nonnull String value) {
            this.toHash = Objects.requireNonNull(value, "value");
            return (B)this.self();
        }

        @Override
        @Nonnull
        public B type(@Nonnull RefChangeType value) {
            return (B)((AbstractBuilder)super.type(value));
        }

        @Override
        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder() {
        }

        public Builder(@Nonnull RefChange refChange) {
            super(refChange);
        }

        @Override
        @Nonnull
        public SimpleRefChange build() {
            return new SimpleRefChange(this.self());
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

