/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;

public class ChangesetsCommandParameters
extends AbstractCommandParameters {
    public static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final Set<String> commitIds;
    private final boolean ignoreMissing;
    private final int maxChangesPerCommit;
    private final int maxMessageLength;

    private ChangesetsCommandParameters(Builder builder) {
        this.commitIds = builder.commitIds.build();
        this.ignoreMissing = builder.ignoreMissing;
        this.maxChangesPerCommit = builder.maxChangesPerCommit;
        this.maxMessageLength = builder.maxMessageLength;
        if (this.commitIds.isEmpty()) {
            throw new IllegalStateException("At least one commit ID must be provided to retrieve changesets");
        }
        if (this.maxChangesPerCommit < 1) {
            throw new IllegalStateException("The maximum number of changes to include per commit must be greater than 0");
        }
    }

    @Nonnull
    public Set<String> getCommitIds() {
        return this.commitIds;
    }

    public int getMaxChangesPerCommit() {
        return this.maxChangesPerCommit;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> commitIds = ImmutableSet.builder();
        private boolean ignoreMissing;
        private int maxChangesPerCommit;
        private int maxMessageLength = -1;

        @Nonnull
        public ChangesetsCommandParameters build() {
            return new ChangesetsCommandParameters(this);
        }

        @Nonnull
        public Builder commitId(@Nullable String value) {
            ChangesetsCommandParameters.addIf(NOT_BLANK, this.commitIds, value);
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nullable String value, String ... values) {
            ChangesetsCommandParameters.addIf(NOT_BLANK, this.commitIds, value, values);
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nullable Iterable<String> values) {
            ChangesetsCommandParameters.addIf(NOT_BLANK, this.commitIds, values);
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public Builder maxChangesPerCommit(int value) {
            this.maxChangesPerCommit = value;
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }
    }
}

