/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AsyncCommand;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;

public interface Command<T>
extends Callable<T> {
    @Nonnull
    public AsyncCommand<T> asynchronous();

    @Override
    @Nullable
    public T call();

    public void setExecutionTimeout(long var1);

    default public void setExecutionTimeout(@Nonnull Duration timeout) {
        this.setExecutionTimeout(Objects.requireNonNull(timeout, "timeout").getSeconds());
    }

    public void setIdleTimeout(long var1);

    default public void setIdleTimeout(@Nonnull Duration timeout) {
        this.setIdleTimeout(Objects.requireNonNull(timeout, "timeout").getSeconds());
    }

    default public void setTimeout(long timeoutInSecs) {
        this.setExecutionTimeout(timeoutInSecs);
        this.setIdleTimeout(timeoutInSecs);
    }

    default public void setTimeout(@Nonnull Duration timeout) {
        this.setExecutionTimeout(timeout);
        this.setIdleTimeout(timeout);
    }
}

