/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PushCommandParameters {
    private final boolean anonymous;
    private final Map<String, String> environment;
    private final boolean force;
    private final boolean includePrivateRefs;
    private final String password;
    private final File privateKeyFile;
    private final boolean prune;
    private final Set<String> refspecs;
    private final String remoteUrl;
    private final String username;

    private PushCommandParameters(Builder builder) {
        boolean credentialsSupplied;
        this.environment = builder.environment.build();
        this.force = builder.force;
        this.includePrivateRefs = builder.includePrivateRefs;
        this.password = builder.password;
        this.privateKeyFile = builder.privateKeyFile;
        this.prune = builder.prune;
        this.remoteUrl = builder.remoteUrl;
        this.refspecs = builder.refspecs.build();
        this.username = builder.username;
        boolean bl = credentialsSupplied = this.username != null || this.password != null || this.privateKeyFile != null;
        boolean bl2 = builder.anonymous == null ? !credentialsSupplied : (this.anonymous = builder.anonymous.booleanValue());
        if (!this.anonymous && !credentialsSupplied) {
            throw new IllegalArgumentException("No credentials supplied, and 'anonymous' is not set");
        }
        if (this.anonymous && credentialsSupplied) {
            throw new IllegalArgumentException("Credentials supplied even though 'anonymous' is set");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushCommandParameters that = (PushCommandParameters)o;
        return this.anonymous == that.anonymous && this.includePrivateRefs == that.includePrivateRefs && this.force == that.force && this.prune == that.prune && Objects.equals(this.password, that.password) && Objects.equals(this.privateKeyFile, that.privateKeyFile) && Objects.equals(this.refspecs, that.refspecs) && Objects.equals(this.remoteUrl, that.remoteUrl) && Objects.equals(this.username, that.username);
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Nonnull
    public Optional<File> getPrivateKey() {
        return Optional.ofNullable(this.privateKeyFile);
    }

    @Nonnull
    public Set<String> getRefspecs() {
        return this.refspecs;
    }

    @Nonnull
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    @Nonnull
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public int hashCode() {
        return Objects.hash(this.anonymous, this.includePrivateRefs, this.password, this.privateKeyFile, this.force, this.prune, this.refspecs, this.remoteUrl, this.username);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isIncludePrivateRefs() {
        return this.includePrivateRefs;
    }

    public boolean isPrune() {
        return this.prune;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("includePrivateRefs", this.includePrivateRefs).add("password", (Object)"<hidden>").add("force", this.force).add("prune", this.prune).add("refspecs", this.refspecs).add("remoteUrl", (Object)this.remoteUrl).add("username", (Object)this.username).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableMap.Builder<String, String> environment;
        private final ImmutableSet.Builder<String> refspecs;
        private final String remoteUrl;
        private Boolean anonymous;
        private boolean force;
        private boolean includePrivateRefs;
        private String password;
        private File privateKeyFile;
        private boolean prune;
        private String username;

        public Builder(@Nonnull String remoteUrl) {
            this.remoteUrl = Builder.requireNonBlank(remoteUrl, "remoteUrl");
            this.environment = ImmutableMap.builder();
            this.force = false;
            this.includePrivateRefs = true;
            this.prune = false;
            this.refspecs = ImmutableSet.builder();
        }

        public Builder(@Nonnull PushCommandParameters pushCommandParameters) {
            this.environment = ImmutableMap.builder().putAll(pushCommandParameters.environment);
            this.remoteUrl = pushCommandParameters.getRemoteUrl();
            this.includePrivateRefs = pushCommandParameters.isIncludePrivateRefs();
            this.password = pushCommandParameters.getPassword().orElse(null);
            this.privateKeyFile = pushCommandParameters.getPrivateKey().orElse(null);
            this.prune = pushCommandParameters.isPrune();
            this.username = pushCommandParameters.getUsername().orElse(null);
            this.refspecs = ImmutableSet.builder();
            this.refspecs.addAll(pushCommandParameters.getRefspecs());
        }

        @Nonnull
        public Builder anonymous(boolean value) {
            this.anonymous = value;
            return this;
        }

        @Nonnull
        public PushCommandParameters build() {
            return new PushCommandParameters(this);
        }

        @Nonnull
        public Builder force(boolean value) {
            this.force = value;
            return this;
        }

        @Nonnull
        public Builder includePrivateRefs(boolean value) {
            this.includePrivateRefs = value;
            return this;
        }

        @Nonnull
        public Builder password(@Nonnull String value) {
            this.password = Objects.requireNonNull(value, "password");
            return this;
        }

        @Nonnull
        public Builder privateKey(@Nonnull File value) {
            this.privateKeyFile = Objects.requireNonNull(value, "privateKeyFile");
            return this;
        }

        @Nonnull
        public Builder privateKey(@Nonnull Path value) {
            return this.privateKey(Objects.requireNonNull(value, "privateKeyFile").toFile());
        }

        @Nonnull
        public Builder prune(boolean value) {
            this.prune = value;
            return this;
        }

        @Nonnull
        public Builder refspecs(@Nonnull Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.refspecs, values);
            return this;
        }

        @Nonnull
        public Builder username(@Nonnull String value) {
            this.username = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder withEnvironment(@Nonnull String name, @Nonnull String value) {
            this.environment.put((Object)Builder.requireNonBlank(name, "name"), (Object)Builder.requireNonBlank(value, "value"));
            return this;
        }
    }
}

