/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSetMultimap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BulkCommitsCommandParameters
extends AbstractCommandParameters {
    private final Map<Repository, Set<String>> commits;
    private final boolean ignoringMissing;
    private final int maxMessageLength;
    private final boolean withMessages;

    private BulkCommitsCommandParameters(Builder builder) {
        this.commits = builder.commits.build().asMap();
        this.ignoringMissing = builder.ignoringMissing;
        this.maxMessageLength = builder.withMessages ? Math.max(-1, builder.maxMessageLength) : 0;
        this.withMessages = builder.withMessages && this.maxMessageLength != 0;
    }

    @Nonnull
    public Map<Repository, Set<String>> getCommits() {
        return this.commits;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public boolean isIgnoringMissing() {
        return this.ignoringMissing;
    }

    public boolean isWithMessages() {
        return this.withMessages;
    }

    public static class Builder {
        private final ImmutableSetMultimap.Builder<Repository, String> commits;
        private boolean ignoringMissing;
        private int maxMessageLength;
        private boolean withMessages;

        public Builder() {
            this.commits = ImmutableSetMultimap.builder();
            this.maxMessageLength = -1;
            this.withMessages = true;
        }

        public Builder(@Nonnull BulkCommitsRequest request) {
            Objects.requireNonNull(request, "request");
            this.commits = ImmutableSetMultimap.builder();
            this.ignoringMissing = request.isIgnoringMissing();
            this.maxMessageLength = request.getMaxMessageLength().orElse(-1);
            this.withMessages = true;
            request.getCommits().forEach((arg_0, arg_1) -> this.commits.putAll(arg_0, arg_1));
        }

        @Nonnull
        public BulkCommitsCommandParameters build() {
            return new BulkCommitsCommandParameters(this);
        }

        @Nonnull
        public Builder commit(@Nonnull Repository repository, @Nonnull String value) {
            this.commits.put((Object)Objects.requireNonNull(repository, "repository"), (Object)BulkCommitsCommandParameters.requireNonBlank(value, "commit"));
            return this;
        }

        @Nonnull
        public Builder commits(@Nonnull Repository repository, @Nonnull Iterable<String> values) {
            this.commits.putAll((Object)Objects.requireNonNull(repository, "repository"), Objects.requireNonNull(values, "commits"));
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoringMissing = value;
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Nonnull
        public Builder withMessages(boolean value) {
            this.withMessages = value;
            return this;
        }
    }
}

