/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class MirrorUpdateRefsCommandParameters
extends AbstractCommandParameters {
    private final List<RefChange> changes;

    private MirrorUpdateRefsCommandParameters(Builder builder) {
        this.changes = builder.changes.build();
    }

    @Nonnull
    public List<RefChange> getChanges() {
        return this.changes;
    }

    public static class Builder {
        private final ImmutableList.Builder<RefChange> changes = ImmutableList.builder();

        @Nonnull
        public MirrorUpdateRefsCommandParameters build() {
            return new MirrorUpdateRefsCommandParameters(this);
        }

        @Nonnull
        public Builder change(RefChange value) {
            MirrorUpdateRefsCommandParameters.addIf(Objects::nonNull, this.changes, Builder.copy(value));
            return this;
        }

        @Nonnull
        public Builder changes(@Nonnull Iterable<? extends RefChange> values) {
            Objects.requireNonNull(values, "changes").forEach(this::change);
            return this;
        }

        private static RefChange copy(RefChange value) {
            return value == null ? null : new SimpleRefChange.Builder(value).build();
        }
    }
}

