/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.ref;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;

public class LsRemoteCommandParameters
extends AbstractCommandParameters {
    private final String cloneUrl;
    private final Map<String, String> environment;
    private final Duration idleTimeout;
    private final File privateKey;
    private final Repository repository;
    private final Duration syncTimeout;

    protected LsRemoteCommandParameters(Builder builder) {
        this.cloneUrl = builder.cloneUrl;
        this.environment = builder.environment.build();
        this.idleTimeout = builder.idleTimeout;
        this.privateKey = builder.privateKey;
        this.repository = builder.repository;
        this.syncTimeout = builder.syncTimeout;
    }

    @Nonnull
    public String getCloneUrl() {
        return this.cloneUrl;
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Nonnull
    public File getPrivateKey() {
        return this.privateKey;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Duration getSyncTimeout() {
        return this.syncTimeout;
    }

    public static class Builder
    extends AbstractCommandParameters {
        private final String cloneUrl;
        private final ImmutableMap.Builder<String, String> environment;
        private final Duration idleTimeout;
        private final File privateKey;
        private final Repository repository;
        private final Duration syncTimeout;

        public Builder(@Nonnull String cloneUrl, @Nonnull File privateKey, @Nonnull Repository repository, @Nonnull Duration idleTimeout, @Nonnull Duration syncTimeout) {
            this.cloneUrl = Objects.requireNonNull(cloneUrl, "cloneUrl");
            this.environment = ImmutableMap.builder();
            this.idleTimeout = Objects.requireNonNull(idleTimeout, "idleTimeout");
            this.privateKey = Objects.requireNonNull(privateKey, "privateKey");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.syncTimeout = Objects.requireNonNull(syncTimeout, "syncTimeout");
        }

        @Nonnull
        public LsRemoteCommandParameters build() {
            return new LsRemoteCommandParameters(this);
        }

        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public Builder withEnvironment(@Nonnull String name, @Nonnull String value) {
            this.environment.put((Object)Builder.requireNonBlank(name, "name"), (Object)Builder.requireNonBlank(value, "value"));
            return this.self();
        }
    }
}

