/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.signed;

import com.atlassian.bitbucket.scm.signed.SignedObjectIdSource;
import jakarta.annotation.Nonnull;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class InteractiveSignedObjectIdSource
implements SignedObjectIdSource {
    private static final String COMPLETE = "\u0000\u0000____________COMPLETE____________\u0000\u0000";
    private final BlockingQueue<String> items = new LinkedBlockingDeque<String>();
    private volatile boolean complete;
    private volatile String next;

    public void add(@Nonnull String objectId) {
        if (this.complete) {
            throw new IllegalStateException("Already completed");
        }
        this.items.offer(Objects.requireNonNull(objectId, "objectId"));
    }

    public void complete() {
        this.complete = true;
        this.items.offer(COMPLETE);
    }

    @Override
    public boolean hasNext() {
        while (!(this.next != null || this.complete && this.items.isEmpty())) {
            try {
                this.next = this.items.poll(500L, TimeUnit.MILLISECONDS);
                if (this.next != COMPLETE) continue;
                this.next = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return this.next != null;
    }

    @Override
    @Nonnull
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String objectId = this.next;
        this.next = null;
        return objectId;
    }
}

