/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scope;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class Scopes {
    private static final GlobalScope GLOBAL = new GlobalScope();

    private Scopes() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static GlobalScope global() {
        return GLOBAL;
    }

    @Nonnull
    public static ProjectScope project(@Nonnull Project project) {
        return new ProjectScope(Objects.requireNonNull(project, "project"));
    }

    @Nonnull
    public static RepositoryScope repository(@Nonnull Repository repository) {
        return new RepositoryScope(Objects.requireNonNull(repository, "repository"));
    }
}

