/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.topic;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class TopicSettings<T extends Serializable> {
    public static final int QUEUE_SIZE_DEFAULT = -1;
    private final boolean dedupePendingMessages;
    private final Class<T> messageType;
    private final int queueSize;

    private TopicSettings(Builder<T> builder) {
        this.dedupePendingMessages = builder.dedupePendingMessages;
        this.messageType = builder.messageType;
        this.queueSize = builder.queueSize;
    }

    @Nonnull
    public static <T extends Serializable> Builder<T> builder(@Nullable Class<T> messageType) {
        return new Builder<T>(messageType);
    }

    @Nonnull
    public Optional<Class<T>> getMessageType() {
        return Optional.ofNullable(this.messageType);
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isDedupePendingMessages() {
        return this.dedupePendingMessages;
    }

    public static class Builder<T extends Serializable> {
        private boolean dedupePendingMessages;
        private Class<T> messageType;
        private int queueSize;

        public Builder(@Nonnull TopicSettings<T> settings) {
            this.dedupePendingMessages = Objects.requireNonNull(settings, "settings").isDedupePendingMessages();
            this.messageType = settings.getMessageType().orElse(null);
            this.queueSize = settings.getQueueSize();
        }

        public Builder(@Nullable Class<T> messageType) {
            this.messageType = messageType;
            this.dedupePendingMessages = false;
            this.queueSize = -1;
        }

        @Nonnull
        public TopicSettings<T> build() {
            return new TopicSettings(this);
        }

        @Nonnull
        public Builder<T> dedupePendingMessages(boolean value) {
            this.dedupePendingMessages = value;
            return this;
        }

        @Nonnull
        public Builder<T> queueSize(int value) {
            Preconditions.checkArgument((value == -1 || value > 0 ? 1 : 0) != 0, (Object)"Queue size must be greater than 0");
            this.queueSize = value;
            return this;
        }
    }
}

