/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.user.AbstractServiceUserRequest;
import com.atlassian.bitbucket.user.ServiceUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ServiceUserUpdateRequest
extends AbstractServiceUserRequest {
    private final int id;

    private ServiceUserUpdateRequest(Builder builder) {
        super(builder);
        this.id = builder.id;
    }

    public int getId() {
        return this.id;
    }

    public static class Builder
    extends AbstractServiceUserRequest.AbstractBuilder<Builder> {
        private Integer id;

        public Builder(int id) {
            this.id = id;
        }

        public Builder(@Nonnull ServiceUser user) {
            this.id = Objects.requireNonNull(user, "user").getId();
            this.active(user.isActive());
            this.displayName(user.getDisplayName());
            this.emailAddress(user.getEmailAddress());
            this.label(user.getLabel());
            this.name(user.getName());
        }

        @Nonnull
        public ServiceUserUpdateRequest build() {
            return new ServiceUserUpdateRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

