/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class UserErasureRequest {
    private final ApplicationUser updatedUser;
    private final String originalUsername;

    private UserErasureRequest(Builder builder) {
        this.updatedUser = builder.newUser;
        this.originalUsername = builder.previousUsername;
    }

    @Nonnull
    public ApplicationUser getUpdatedUser() {
        return this.updatedUser;
    }

    @Nonnull
    public String getOriginalUsername() {
        return this.originalUsername;
    }

    public static class Builder {
        private final ApplicationUser newUser;
        private final String previousUsername;

        public Builder(@Nonnull ApplicationUser updatedUser, @Nonnull String originalUsername) {
            Objects.requireNonNull(updatedUser, "updatedUser");
            Objects.requireNonNull(originalUsername, "originalUsername");
            this.newUser = updatedUser;
            this.previousUsername = originalUsername;
        }

        public UserErasureRequest build() {
            return new UserErasureRequest(this);
        }
    }
}

