/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

public interface DateFormatter {
    public static final String PROPERTY_KEY_PREFIX = "bitbucket.date.format";

    @Nonnull
    public String formatDate(@Nonnull Date var1, @Nonnull FormatType var2);

    @Nonnull
    public String formatInstant(@Nonnull Instant var1, @Nonnull FormatType var2);

    @Nullable
    public String getFormatString(@Nullable String var1);

    public static enum FormatType {
        DATETIME("bitbucket.date.format.datetime"),
        FULL("bitbucket.date.format.full"),
        LONG("bitbucket.date.format.long"),
        LONGAGE(LONG),
        SHORT("bitbucket.date.format.short"),
        SHORTAGE(SHORT),
        TIMEONLY("bitbucket.date.format.timeonly"),
        TIMESTAMP("bitbucket.date.format.timestamp");

        final String key;
        final boolean age;

        private FormatType(FormatType delegate) {
            this.key = delegate.key;
            this.age = true;
        }

        private FormatType(String key) {
            this.key = key;
            this.age = false;
        }

        public boolean isAge() {
            return this.age;
        }

        public String getKey() {
            return this.key;
        }

        @Nonnull
        public static FormatType fromString(@Nonnull String s) {
            return FormatType.valueOf(Objects.requireNonNull(s).toUpperCase(Locale.ROOT));
        }
    }
}

