/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import jakarta.annotation.Nonnull;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MoreStreams {
    private MoreStreams() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static <T> Iterable<T> asIterable(@Nonnull Stream<T> stream) {
        return Objects.requireNonNull(stream, "stream")::iterator;
    }

    @Nonnull
    public static <T> Stream<T> streamEnumeration(final @Nonnull Enumeration<T> enumeration) {
        Objects.requireNonNull(enumeration, "enumeration");
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (enumeration.hasMoreElements()) {
                    action.accept(enumeration.nextElement());
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (enumeration.hasMoreElements()) {
                    action.accept(enumeration.nextElement());
                    return true;
                }
                return false;
            }
        }, false);
    }

    @Nonnull
    public static <T> Stream<T> streamIterable(@Nonnull Iterable<T> iterable) {
        return StreamSupport.stream(Objects.requireNonNull(iterable, "iterable").spliterator(), false);
    }

    @Nonnull
    public static <T> Stream<T> streamOptional(@Nonnull Optional<T> optional) {
        return Objects.requireNonNull(optional, "optional").map(Stream::of).orElseGet(Stream::empty);
    }
}

