/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Page<T> {
    default public void forEach(@Nonnull Consumer<? super T> action) {
        this.stream().forEach(action);
    }

    public boolean getIsLastPage();

    public int getLimit();

    @Nullable
    public PageRequest getNextPageRequest();

    @Nonnull
    public SortedMap<Integer, T> getOrdinalIndexedValues();

    public int getSize();

    public int getStart();

    @Nonnull
    public Iterable<T> getValues();

    @Nonnull
    default public Stream<T> stream() {
        return MoreStreams.streamIterable(this.getValues());
    }

    @Nonnull
    public <E> Page<E> transform(@Nonnull Function<? super T, ? extends E> var1);
}

