/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.NamedLink;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class SimpleNamedLink
implements NamedLink {
    private final String href;
    private final String name;

    public SimpleNamedLink(@Nonnull String href, @Nonnull String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)href), (Object)"href must be supplied");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name must be supplied");
        this.href = href;
        this.name = name;
    }

    @Override
    @Nonnull
    public String getHref() {
        return this.href;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleNamedLink that = (SimpleNamedLink)o;
        return this.name.equals(that.name) && this.href.equals(that.href);
    }

    public int hashCode() {
        int result = this.href.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "SimpleNamedLink{href='" + this.href + "', name='" + this.name + "'}";
    }
}

