/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.validation.annotation.ConditionalNotEmpty;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public class ConditionalNotEmptyValidator
implements ConstraintValidator<ConditionalNotEmpty, Object> {
    private String[] fields;
    private String message;
    private String targetField;

    public void initialize(ConditionalNotEmpty constraint) {
        this.fields = constraint.fields();
        this.targetField = constraint.targetField();
        this.message = constraint.message();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        boolean valid = true;
        if (this.isBlank(object, this.targetField) && this.oneOrMoreFieldsNotEmpty(object, this.fields)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.message).addNode(this.targetField).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    private boolean oneOrMoreFieldsNotEmpty(Object value, String[] fields) {
        for (String fieldName : fields) {
            if (this.isBlank(value, fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlank(Object value, String fieldName) {
        try {
            Object fieldValue;
            Field field = this.findField(value, fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (fieldValue = field.get(value)) == null || StringUtils.isBlank((CharSequence)fieldValue.toString());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Invalid field: " + fieldName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Inaccessible field: " + fieldName);
        }
    }

    private Field findField(Object value, String name) throws NoSuchFieldException {
        for (Class<?> clazz = value.getClass(); !Object.class.equals(clazz) && clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException(name);
    }
}

