/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.watcher;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.Watchable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class AbstractWatcherRequest {
    private final ApplicationUser user;
    private final Watchable watchable;

    protected AbstractWatcherRequest(@Nonnull AbstractBuilder<?, ?> builder) {
        this.user = builder.user;
        this.watchable = builder.watchable;
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Nonnull
    public Watchable getWatchable() {
        return this.watchable;
    }

    protected static abstract class AbstractBuilder<B, R> {
        private final Watchable watchable;
        private ApplicationUser user;

        public AbstractBuilder(@Nonnull Watchable watchable) {
            this.watchable = Objects.requireNonNull(watchable, "watchable");
        }

        @Nonnull
        public B user(@Nullable ApplicationUser value) {
            this.user = value;
            return this.self();
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        protected abstract B self();
    }
}

