/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.watcher;

import com.atlassian.bitbucket.watcher.Watchable;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class WatcherSearchRequest {
    private final boolean transitive;
    private final Watchable watchable;

    private WatcherSearchRequest(@Nonnull Builder builder) {
        this.transitive = builder.transitive;
        this.watchable = builder.watchable;
    }

    @Nonnull
    public Watchable getWatchable() {
        return this.watchable;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public static class Builder {
        private final Watchable watchable;
        private boolean transitive;

        public Builder(@Nonnull Watchable value) {
            this.watchable = Objects.requireNonNull(value, "watchable");
        }

        @Nonnull
        public WatcherSearchRequest build() {
            return new WatcherSearchRequest(this);
        }

        @Nonnull
        public Builder transitive(boolean value) {
            this.transitive = value;
            return this;
        }
    }
}

