/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.configuration;

import com.atlassian.analytics.api.events.AnalyticsConfigChangedEvent;
import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.analytics.client.featureflag.AnalyticsFeatureFlags;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsConfig
implements AnalyticsConfigService {
    private static final String CACHE_KEY = "com.atlassian.analytics.client.configuration.settings-cache";
    private static final String ANALYTICS_OPTION_KEY = "com.atlassian.analytics.client.configuration.analytics-option-cache";
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsConfig.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final EventPublisher eventPublisher;
    private final Cache<String, Boolean> settingsCache;
    private final Cache<String, AnalyticsOption> analyticsOptionCache;
    private final AnalyticsFeatureFlags analyticsFeatureFlags;

    public AnalyticsConfig(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, CacheManager cacheManager, AnalyticsFeatureFlags analyticsFeatureFlags) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.eventPublisher = eventPublisher;
        this.settingsCache = this.getSettingsCache(cacheManager);
        this.analyticsOptionCache = this.getAnalyticsOptionCache(cacheManager);
        this.analyticsFeatureFlags = analyticsFeatureFlags;
    }

    public String getDestination() {
        return this.getSetting(AnalyticsConfigChangedEvent.Key.DESTINATION);
    }

    public String getDestinationOrDefault(String defaultDestination) {
        String destination = this.getDestination();
        return StringUtils.isNotEmpty((CharSequence)destination) ? destination : defaultDestination;
    }

    public void setDestination(String destination) {
        Preconditions.checkNotNull((Object)destination);
        this.updateSetting(AnalyticsConfigChangedEvent.Key.DESTINATION, destination);
    }

    public boolean isPolicyUpdateAcknowledged() {
        return (Boolean)this.settingsCache.get((Object)AnalyticsConfigChangedEvent.Key.POLICY_ACKNOWLEDGED.name());
    }

    public void setPolicyUpdateAcknowledged(boolean acknowledged) {
        boolean updateSuccessful = this.updateSetting(AnalyticsConfigChangedEvent.Key.POLICY_ACKNOWLEDGED, acknowledged);
        if (updateSuccessful) {
            this.settingsCache.put((Object)AnalyticsConfigChangedEvent.Key.POLICY_ACKNOWLEDGED.name(), (Object)acknowledged);
        }
    }

    @Deprecated
    public void setDefaultAnalyticsEnabled() {
        String analyticsEnabled = this.getSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_ENABLED);
        if (StringUtils.isEmpty((CharSequence)analyticsEnabled)) {
            this.setAnalyticsEnabled(true);
        }
    }

    public void setAdvancedAnalyticsByDefaultPreservingExistingSetting() {
        String analyticsEnabled = this.getSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_ENABLED);
        String analyticsOption = this.getSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_OPTION);
        if (StringUtils.isEmpty((CharSequence)analyticsOption)) {
            if (StringUtils.isEmpty((CharSequence)analyticsEnabled)) {
                this.setAnalyticsOption(AnalyticsOption.ADVANCED);
            } else if (Boolean.parseBoolean(analyticsEnabled)) {
                this.setAnalyticsOption(AnalyticsOption.ADVANCED);
            } else {
                this.setAnalyticsOption(AnalyticsOption.DISABLED);
            }
        }
    }

    @Deprecated
    public void handleAnalyticsEnabled(boolean analyticsEnabled, String userName) {
        this.setAnalyticsEnabled(analyticsEnabled);
        if (!analyticsEnabled) {
            this.logUserDisableAnalytics(userName);
        }
        this.setAnalyticsOption(analyticsEnabled ? AnalyticsOption.ADVANCED : AnalyticsOption.DISABLED);
    }

    @Deprecated
    public void setAnalyticsEnabled(boolean analyticsEnabled) {
        boolean updateSuccessful = this.updateSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_ENABLED, analyticsEnabled);
        if (updateSuccessful) {
            this.settingsCache.put((Object)AnalyticsConfigChangedEvent.Key.ANALYTICS_ENABLED.name(), (Object)analyticsEnabled);
        }
    }

    public void handleAnalyticOption(String option, String userName) {
        AnalyticsOption analyticsOption = AnalyticsOption.valueOf(option);
        this.setAnalyticsOption(analyticsOption);
        if (analyticsOption == AnalyticsOption.DISABLED) {
            this.logUserDisableAnalytics(userName);
        }
        this.setAnalyticsEnabled(analyticsOption == AnalyticsOption.ADVANCED);
    }

    public AnalyticsOption getAnalyticsOption() {
        return this.getAnalyticOptionSettingFromCache();
    }

    public boolean isAnalyticsDisabled() {
        return this.getAnalyticOptionSettingFromCache() == AnalyticsOption.DISABLED;
    }

    public boolean isBasicAnalyticsEnabled() {
        return this.getAnalyticOptionSettingFromCache() == AnalyticsOption.BASIC;
    }

    public boolean isAdvancedAnalyticsEnabled() {
        return this.getAnalyticOptionSettingFromCache() == AnalyticsOption.ADVANCED;
    }

    @Deprecated
    public boolean isAnalyticsEnabled() {
        return (Boolean)this.settingsCache.get((Object)AnalyticsConfigChangedEvent.Key.ANALYTICS_ENABLED.name());
    }

    public boolean canCollectAnalytics() {
        if (!this.analyticsFeatureFlags.isEssentialAnalyticsEnabled()) {
            return this.isAnalyticsEnabled() && this.isPolicyUpdateAcknowledged();
        }
        return !this.isAnalyticsDisabled() && this.isPolicyUpdateAcknowledged();
    }

    public boolean hasLoggedBaseData() {
        return this.getBooleanSetting(AnalyticsConfigChangedEvent.Key.LOGGED_BASE_DATA);
    }

    public void setLoggedBaseData(boolean loggedBaseData) {
        this.updateSetting(AnalyticsConfigChangedEvent.Key.LOGGED_BASE_DATA, loggedBaseData);
    }

    private void setAnalyticsOption(AnalyticsOption analyticsOption) {
        boolean updateSuccessful = this.updateSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_OPTION, analyticsOption.name());
        if (updateSuccessful) {
            this.analyticsOptionCache.put((Object)AnalyticsConfigChangedEvent.Key.ANALYTICS_OPTION.name(), (Object)analyticsOption);
        }
    }

    private void logUserDisableAnalytics(String userName) {
        String currentDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        this.updateSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_DISABLED_USERNAME, userName, false);
        this.updateSetting(AnalyticsConfigChangedEvent.Key.ANALYTICS_DISABLED_DATE, currentDateTime, false);
    }

    private boolean updateSetting(AnalyticsConfigChangedEvent.Key key, boolean newValue) {
        return this.updateSetting(key, Boolean.toString(newValue), true);
    }

    private boolean updateSetting(AnalyticsConfigChangedEvent.Key key, String newValue) {
        return this.updateSetting(key, newValue, true);
    }

    private boolean updateSetting(AnalyticsConfigChangedEvent.Key key, String newValue, boolean fireEvent) {
        String oldValue = this.getSetting(key);
        boolean putSuccessful = this.putSetting(key, newValue);
        if (fireEvent && putSuccessful) {
            this.eventPublisher.publish((Object)new AnalyticsConfigChangedEvent(key, oldValue, newValue));
        }
        return putSuccessful;
    }

    private AnalyticsOption getAnalyticOptionSettingFromCache() {
        return (AnalyticsOption)((Object)this.analyticsOptionCache.get((Object)AnalyticsConfigChangedEvent.Key.ANALYTICS_OPTION.name()));
    }

    private Cache<String, AnalyticsOption> getAnalyticsOptionCache(CacheManager cacheManager) {
        CacheLoader cacheLoader = key -> this.getAnalyticsOptionSetting(AnalyticsConfigChangedEvent.Key.valueOf((String)key));
        return cacheManager.getCache(ANALYTICS_OPTION_KEY, cacheLoader, this.getCacheSettings());
    }

    private Cache<String, Boolean> getSettingsCache(CacheManager cacheManager) {
        CacheLoader cacheLoader = key -> this.getBooleanSetting(AnalyticsConfigChangedEvent.Key.valueOf((String)key));
        return cacheManager.getCache(CACHE_KEY, cacheLoader, this.getCacheSettings());
    }

    private CacheSettings getCacheSettings() {
        return new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build();
    }

    private Boolean getBooleanSetting(AnalyticsConfigChangedEvent.Key key) {
        String value = this.getSetting(key);
        return StringUtils.isNotEmpty((CharSequence)value) && Boolean.parseBoolean(value);
    }

    private String getSetting(AnalyticsConfigChangedEvent.Key key) {
        try {
            String setting = (String)this.pluginSettingsFactory.createGlobalSettings().get(key.getKey());
            return setting == null ? "" : setting;
        }
        catch (RuntimeException e) {
            LOG.warn("Couldn't check the analytics settings. This can safely be ignored during plugin shutdown. Detail: ", (Throwable)e);
            return "";
        }
    }

    private boolean putSetting(AnalyticsConfigChangedEvent.Key key, String newValue) {
        try {
            this.pluginSettingsFactory.createGlobalSettings().put(key.getKey(), (Object)newValue);
            return true;
        }
        catch (RuntimeException e) {
            LOG.warn("Couldn't change the analytics settings. This can safely be ignored during plugin shutdown. Detail: ", (Throwable)e);
            return false;
        }
    }

    private AnalyticsOption getAnalyticsOptionSetting(AnalyticsConfigChangedEvent.Key key) {
        try {
            String setting = (String)this.pluginSettingsFactory.createGlobalSettings().get(key.getKey());
            return setting == null ? AnalyticsOption.DISABLED : AnalyticsOption.valueOf(setting);
        }
        catch (RuntimeException e) {
            LOG.warn("Couldn't check the analytics option settings. This can safely be ignored during plugin shutdown. Detail: ", (Throwable)e);
            return AnalyticsOption.DISABLED;
        }
    }

    public static enum AnalyticsOption {
        ADVANCED,
        BASIC,
        DISABLED;

    }
}

