/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.configuration;

import com.atlassian.analytics.client.UserPermissionsHelper;
import com.atlassian.analytics.client.configuration.AnalyticsConfig;
import com.atlassian.analytics.client.configuration.entities.AnalyticsConfigDestinationEntity;
import com.atlassian.analytics.client.configuration.entities.AnalyticsConfigOptionEntity;
import com.atlassian.analytics.client.configuration.entities.ErrorEntity;
import com.atlassian.analytics.client.featureflag.AnalyticsFeatureFlags;
import com.atlassian.analytics.client.s3.S3UploadException;
import com.atlassian.analytics.client.upload.PeriodicEventUploaderScheduler;
import com.atlassian.analytics.client.upload.S3ConnectivityChecker;
import com.atlassian.annotations.security.SystemAdminOnly;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Path(value="/config")
@Produces(value={"application/json;charset=UTF-8"})
public class AnalyticsConfigResource {
    private final AnalyticsConfig analyticsConfig;
    private final UserPermissionsHelper userPermissionsHelper;
    private final PeriodicEventUploaderScheduler periodicEventUploaderScheduler;
    private final AnalyticsFeatureFlags analyticsFeatureFlags;
    private final S3ConnectivityChecker s3ConnectivityChecker;

    @Inject
    public AnalyticsConfigResource(AnalyticsConfig analyticsConfig, UserPermissionsHelper userPermissionsHelper, PeriodicEventUploaderScheduler periodicEventUploaderScheduler, AnalyticsFeatureFlags analyticsFeatureFlags, S3ConnectivityChecker s3ConnectivityChecker) {
        this.analyticsConfig = analyticsConfig;
        this.userPermissionsHelper = userPermissionsHelper;
        this.periodicEventUploaderScheduler = periodicEventUploaderScheduler;
        this.analyticsFeatureFlags = analyticsFeatureFlags;
        this.s3ConnectivityChecker = s3ConnectivityChecker;
    }

    @GET
    public Response getAnalyticsDestination() {
        return Response.ok((Object)new AnalyticsConfigDestinationEntity(this.analyticsConfig.getDestination())).build();
    }

    @Path(value="/destination")
    @PUT
    public Response setAnalyticsDestination(@Context HttpServletRequest request, @FormParam(value="destination") String destination) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.analyticsConfig.setDestination(destination);
        return Response.ok((Object)new AnalyticsConfigDestinationEntity(this.analyticsConfig.getDestination())).build();
    }

    @Path(value="/enable")
    @PUT
    public Response setAnalyticsEnabled(@Context HttpServletRequest request, AnalyticsConfigOptionEntity analyticsConfigOptionEntity) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            if (this.analyticsFeatureFlags.isEssentialAnalyticsEnabled()) {
                this.analyticsConfig.handleAnalyticOption(analyticsConfigOptionEntity.getAnalyticsOption(), request.getRemoteUser());
            } else {
                this.analyticsConfig.handleAnalyticsEnabled(analyticsConfigOptionEntity.isAnalyticsEnabled(), request.getRemoteUser());
            }
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Path(value="/acknowledge")
    @PUT
    public Response setPolicyAcknowledged(@Context HttpServletRequest request) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.analyticsConfig.setPolicyUpdateAcknowledged(true);
        this.periodicEventUploaderScheduler.runJob(PeriodicEventUploaderScheduler.JobType.REMOTE_FILTER_READ);
        return Response.ok().build();
    }

    @Path(value="/upload")
    @GET
    public Response triggerUploadScheduledJob(@Context HttpServletRequest request) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.periodicEventUploaderScheduler.runJob(PeriodicEventUploaderScheduler.JobType.S3_EVENT_UPLOAD);
        return Response.ok().build();
    }

    @Path(value="/connectivity-check")
    @GET
    public Response connectivityCheck(@Context HttpServletRequest request) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            if (!this.s3ConnectivityChecker.isS3Accessible()) {
                return Response.serverError().build();
            }
        }
        catch (S3UploadException e) {
            return AnalyticsConfigResource.getResponseFromS3UploadException(e);
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    private static Response getResponseFromS3UploadException(S3UploadException e) {
        if (e == null || e.getMessage() == null) {
            return Response.serverError().build();
        }
        ErrorEntity errorEntity = new ErrorEntity();
        errorEntity.setErrorMessage(e.getMessage());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorEntity).build();
    }
}

