/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.featureflag;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class AnalyticsFeatureFlags {
    public static final String DARK_FEATURE_AUTO_WHITELIST_GROW_EVENTS_KEY = "com.atlassian.analytics.auto.whitelist.grow.events";
    public static final String DARK_FEATURE_ESSENTIAL_ANALYTICS_SUPPORTED_KEY = "com.atlassian.analytics.essential.supported";
    public static final String DARK_FEATURE_EVENT_REPORT_KEY = "com.atlassian.analytics.eventreport";
    public static final String DARK_FEATURE_TEST_DATA_CONNECTION_KEY = "com.atlassian.analytics.test.data.connection";
    private final Cache<String, Boolean> cache;
    private final DarkFeatureManager darkFeatureManager;

    public AnalyticsFeatureFlags(CacheManager cacheManager, DarkFeatureManager darkFeatureManager) {
        this.cache = cacheManager.getCache(AnalyticsFeatureFlags.class.getName() + ".cache", (CacheLoader)new FeatureFlagCacheLoader(), new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterWrite(5L, TimeUnit.MINUTES).build());
        this.darkFeatureManager = darkFeatureManager;
    }

    public boolean isAutoWhitelistGrowEventsEnabled() {
        return this.isFeatureFlagEnabled(DARK_FEATURE_AUTO_WHITELIST_GROW_EVENTS_KEY);
    }

    public boolean isEssentialAnalyticsEnabled() {
        return this.isFeatureFlagEnabled(DARK_FEATURE_ESSENTIAL_ANALYTICS_SUPPORTED_KEY);
    }

    public boolean isEventReportEnabled() {
        return this.isFeatureFlagEnabled(DARK_FEATURE_EVENT_REPORT_KEY);
    }

    public boolean isTestDataConnectionEnabled() {
        return this.isFeatureFlagEnabled(DARK_FEATURE_TEST_DATA_CONNECTION_KEY);
    }

    private boolean isFeatureFlagEnabled(String featureFlagKey) {
        return Boolean.TRUE.equals(this.cache.get((Object)featureFlagKey));
    }

    public void invalidateCache() {
        this.cache.removeAll();
    }

    private class FeatureFlagCacheLoader
    implements CacheLoader<String, Boolean> {
        private FeatureFlagCacheLoader() {
        }

        @Nonnull
        public Boolean load(@Nonnull String featureFlagKey) {
            return AnalyticsFeatureFlags.this.darkFeatureManager.isEnabledForAllUsers(featureFlagKey).orElse(false);
        }
    }
}

