/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.listener;

import com.atlassian.analytics.api.events.AnalyticsPluginReadyEvent;
import com.atlassian.analytics.api.listener.ProductAnalyticsEventListener;
import com.atlassian.analytics.client.eventfilter.whitelist.WhitelistFilter;
import com.atlassian.analytics.client.upload.PeriodicEventUploaderScheduler;
import com.atlassian.analytics.client.uuid.ProductUUIDProvider;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import org.springframework.beans.factory.DisposableBean;

public class BambooEventListener
implements LifecycleAware,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final PluginEventManager pluginEventManager;
    private final ProductAnalyticsEventListener productAnalyticsEventListener;
    private final WhitelistFilter whitelistFilter;
    private final PeriodicEventUploaderScheduler periodicEventUploaderScheduler;
    private final ProductUUIDProvider productUUIDProvider;

    public BambooEventListener(ProductAnalyticsEventListener productAnalyticsEventListener, EventPublisher eventPublisher, PluginEventManager pluginEventManager, WhitelistFilter whitelistFilter, PeriodicEventUploaderScheduler periodicEventUploaderScheduler, ProductUUIDProvider productUUIDProvider) {
        this.productAnalyticsEventListener = productAnalyticsEventListener;
        this.eventPublisher = eventPublisher;
        this.pluginEventManager = pluginEventManager;
        this.whitelistFilter = whitelistFilter;
        this.periodicEventUploaderScheduler = periodicEventUploaderScheduler;
        this.productUUIDProvider = productUUIDProvider;
    }

    private void processEvent(Object event) {
        this.productAnalyticsEventListener.processEvent(event);
    }

    public void onStart() {
        this.productUUIDProvider.createUUID();
        this.whitelistFilter.collectExternalWhitelists();
        this.eventPublisher.register((Object)this);
        this.pluginEventManager.register((Object)this);
        this.eventPublisher.publish((Object)new AnalyticsPluginReadyEvent());
    }

    @PluginEventListener
    public void onPluginEnabledEvent(PluginEnabledEvent event) {
        this.processEvent(event);
    }

    @PluginEventListener
    public void onPluginDisabledEvent(PluginDisabledEvent event) {
        this.processEvent(event);
    }

    @EventListener
    public void onEvent(Object event) {
        this.processEvent(event);
    }

    public void destroy() {
        this.periodicEventUploaderScheduler.unscheduleJobs();
        this.eventPublisher.unregister((Object)this);
    }

    public void onStop() {
    }
}

