/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.logger;

import com.atlassian.analytics.client.logger.AnalyticsLoggerConfigurationBuilder;
import com.atlassian.analytics.client.properties.LoggingProperties;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;

public class AnalyticsConfigurationFactory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";
    private static final String LOG_MESSAGE_LAYOUT_PATTERN = "%m%n";
    private static final String TIME_BASED_FILE_PATTERN_SUFFIX = ".%d{yyyy-MM-dd}.%i.gz";
    private static final int TIME_BASED_TRIGGERING_INTERVAL = 1;
    private final LoggingProperties loggingProperties;

    public AnalyticsConfigurationFactory(@Nonnull LoggingProperties loggingProperties) {
        Objects.requireNonNull(loggingProperties, "The analytics logger information is mandatory.");
        this.loggingProperties = loggingProperties;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        return this.createDefaultConfiguration();
    }

    @Nonnull
    public Configuration createDefaultConfiguration() {
        String analyticsLogPath = this.loggingProperties.getLogPath();
        String analyticsTimeBasedFilePattern = analyticsLogPath.concat(TIME_BASED_FILE_PATTERN_SUFFIX);
        String connectivityCheckLogPath = this.loggingProperties.getConnectivityCheckLogPath();
        String connectivityCheckTimeBasedFilePattern = connectivityCheckLogPath.concat(TIME_BASED_FILE_PATTERN_SUFFIX);
        return new AnalyticsLoggerConfigurationBuilder().withLayoutPattern(LOG_MESSAGE_LAYOUT_PATTERN).withSizeBasedTriggeringPolicy("com.atlassian.analytics.client.btflogger", LoggingProperties.MAX_FILE_SIZE_MB, "MB").withAppenderFileName("com.atlassian.analytics.client.btflogger", analyticsLogPath).withAppenderFilePattern("com.atlassian.analytics.client.btflogger", analyticsTimeBasedFilePattern).withSizeBasedTriggeringPolicy("com.atlassian.analytics.client.btflogger.connectivity.check", 1L, null).withAppenderFileName("com.atlassian.analytics.client.btflogger.connectivity.check", connectivityCheckLogPath).withAppenderFilePattern("com.atlassian.analytics.client.btflogger.connectivity.check", connectivityCheckTimeBasedFilePattern).withTimeBasedTriggeringPolicy(1).withAppenderRolloverStrategy().withLoggerAdditivity().build();
    }

    @Override
    protected String[] getSupportedTypes() {
        return new String[]{ALL_TYPES};
    }
}

