/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.s3;

import com.atlassian.analytics.client.s3.S3UploadException;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class AnalyticsS3Client
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsS3Client.class);
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private final S3Client amazonS3Client;

    public AnalyticsS3Client() {
        this(CredentialsMode.ANONYMOUS);
    }

    public AnalyticsS3Client(CredentialsMode mode) {
        this.amazonS3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(mode.getCredentialsProvider())).httpClient(AnalyticsS3Client.createProxyAwareHttpClient())).dualstackEnabled(Boolean.valueOf(true))).region(Region.US_EAST_1)).build();
    }

    AnalyticsS3Client(S3Client amazonS3Client) {
        this.amazonS3Client = amazonS3Client;
    }

    public void destroy() {
        this.amazonS3Client.close();
    }

    public int uploadFilesToS3Bucket(List<File> filesToUpload, String bucketName, String folderPrefix) throws S3UploadException {
        int filesUploaded = 0;
        for (File file : filesToUpload) {
            try {
                String key = folderPrefix + AnalyticsS3Client.timestamp() + "." + file.getName();
                LOG.debug("Processing {}", (Object)key);
                PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(key).acl(ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL).build();
                this.amazonS3Client.putObject(putObjectRequest, RequestBody.fromFile((File)file));
                ++filesUploaded;
                if (file.delete()) continue;
                file.deleteOnExit();
            }
            catch (AwsServiceException | SdkClientException e) {
                LOG.error("Error sending analytics data to Amazon S3 storage, error message: " + e.getMessage(), e);
                throw new S3UploadException("Failed to upload file(s) to S3", e);
            }
        }
        return filesUploaded;
    }

    private static String timestamp() {
        return String.valueOf(Instant.now().atZone(ZoneId.of("Z")).toEpochSecond());
    }

    public InputStream getS3ObjectInputStream(String bucketName, String filePath) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(filePath).build();
        try {
            return (InputStream)this.amazonS3Client.getObject(getObjectRequest, ResponseTransformer.toInputStream());
        }
        catch (AwsServiceException e) {
            AnalyticsS3Client.logFailedDownloadWarning(filePath, e.getMessage());
            return null;
        }
    }

    public S3Client getAmazonS3Client() {
        return this.amazonS3Client;
    }

    private static void logFailedDownloadWarning(String filePath, String message) {
        LOG.debug("Couldn't download the remote list file {}, detailed message: {}", (Object)filePath, (Object)message);
    }

    private static SdkHttpClient createProxyAwareHttpClient() {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        AnalyticsS3Client.applyProxyProperties(httpClientBuilder);
        return httpClientBuilder.build();
    }

    private static void applyProxyProperties(ApacheHttpClient.Builder clientConfiguration) {
        if (!AnalyticsS3Client.applyProxyProperties(clientConfiguration, HTTPS)) {
            AnalyticsS3Client.applyProxyProperties(clientConfiguration, HTTP);
        }
    }

    private static boolean applyProxyProperties(ApacheHttpClient.Builder clientBuilder, String protocol) {
        String proxyHost = AnalyticsS3Client.getSystemProperty(protocol, "proxyHost");
        String proxyPortString = AnalyticsS3Client.getSystemProperty(protocol, "proxyPort");
        int proxyPort = AnalyticsS3Client.toInt(proxyPortString, -1);
        if (proxyHost == null || proxyPort <= 0) {
            return false;
        }
        String scheme = HTTP;
        ProxyConfiguration.Builder proxyConfigurationBuilder = ProxyConfiguration.builder();
        proxyConfigurationBuilder = proxyConfigurationBuilder.scheme(HTTP).useSystemPropertyValues(Boolean.valueOf(true));
        if (protocol.equals(HTTPS)) {
            String endpoint = "http://" + proxyHost + ":" + proxyPort;
            proxyConfigurationBuilder = proxyConfigurationBuilder.endpoint(URI.create(endpoint));
        }
        clientBuilder.proxyConfiguration((ProxyConfiguration)proxyConfigurationBuilder.build());
        return true;
    }

    private static String getSystemProperty(String protocol, String proxyHost) {
        return System.getProperty(protocol + "." + proxyHost);
    }

    private static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static enum CredentialsMode {
        ANONYMOUS{

            @Override
            AwsCredentialsProvider getCredentialsProvider() {
                return AnonymousCredentialsProvider.create();
            }
        }
        ,
        ENVIRONMENT{

            @Override
            AwsCredentialsProvider getCredentialsProvider() {
                return EnvironmentVariableCredentialsProvider.create();
            }
        }
        ,
        SYSTEM{

            @Override
            AwsCredentialsProvider getCredentialsProvider() {
                return SystemPropertyCredentialsProvider.create();
            }
        };


        abstract AwsCredentialsProvider getCredentialsProvider();
    }
}

