/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.upload;

import com.atlassian.analytics.api.events.AnalyticsConfigStateEvent;
import com.atlassian.analytics.client.configuration.AnalyticsConfig;
import com.atlassian.analytics.client.featureflag.AnalyticsFeatureFlags;
import com.atlassian.analytics.client.upload.AbstractRunner;
import com.atlassian.analytics.client.upload.PeriodicEventUploaderScheduler;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import jakarta.annotation.Nullable;

public class AnalyticsConfigStateRunner
extends AbstractRunner {
    public static final JobId JobId = AnalyticsConfigStateRunner.getJobId(AnalyticsConfigStateRunner.class);
    public static final JobRunnerKey JobRunnerKey = AnalyticsConfigStateRunner.getJobRunnerKey(AnalyticsConfigStateRunner.class);
    private final PeriodicEventUploaderScheduler scheduler;
    private final AnalyticsConfig analyticsConfig;
    private final AnalyticsFeatureFlags analyticsFeatureFlags;
    private final EventPublisher eventPublisher;

    public AnalyticsConfigStateRunner(PeriodicEventUploaderScheduler scheduler, AnalyticsConfig analyticsConfig, AnalyticsFeatureFlags analyticsFeatureFlags, EventPublisher eventPublisher) {
        this.scheduler = scheduler;
        this.analyticsConfig = analyticsConfig;
        this.analyticsFeatureFlags = analyticsFeatureFlags;
        this.eventPublisher = eventPublisher;
    }

    public JobRunnerResponse runJob(@Nullable JobRunnerRequest jobRunnerRequest) {
        this.logger.debug("Executing analytics configuration state runner job.");
        this.scheduler.scheduleJob(PeriodicEventUploaderScheduler.JobType.ANALYTICS_CONFIG_STATE);
        AnalyticsConfigStateEvent event = new AnalyticsConfigStateEvent(this.analyticsConfig.isAnalyticsEnabled(), this.analyticsConfig.getAnalyticsOption().toString(), this.analyticsFeatureFlags.isAutoWhitelistGrowEventsEnabled(), this.analyticsFeatureFlags.isEssentialAnalyticsEnabled(), this.analyticsFeatureFlags.isTestDataConnectionEnabled());
        this.eventPublisher.publish((Object)event);
        return JobRunnerResponse.success();
    }
}

