/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.upload;

import com.atlassian.analytics.client.configuration.AnalyticsConfig;
import com.atlassian.analytics.client.upload.AnalyticsConfigStateRunner;
import com.atlassian.analytics.client.upload.RemoteFilterReadRunner;
import com.atlassian.analytics.client.upload.S3EventUploadRunner;
import com.atlassian.analytics.client.upload.UploadDateCalculator;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicEventUploaderScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicEventUploaderScheduler.class);
    private final AnalyticsConfig analyticsConfig;
    private final SchedulerService schedulerService;

    public PeriodicEventUploaderScheduler(SchedulerService schedulerService, AnalyticsConfig analyticsConfig) {
        this.schedulerService = Objects.requireNonNull(schedulerService);
        this.analyticsConfig = Objects.requireNonNull(analyticsConfig);
    }

    public void initialise() {
        LOG.debug("upload scheduler is being initialized");
        this.analyticsConfig.setDefaultAnalyticsEnabled();
        this.analyticsConfig.setAdvancedAnalyticsByDefaultPreservingExistingSetting();
        this.unscheduleJobs();
        this.runJob(JobType.ANALYTICS_CONFIG_STATE);
        this.scheduleJob(JobType.S3_EVENT_UPLOAD);
        if (this.analyticsConfig.canCollectAnalytics()) {
            LOG.info("Analytics collection is on");
            this.scheduleJob(JobType.REMOTE_FILTER_READ, true);
        }
        LOG.debug("upload scheduler initialization complete");
    }

    public void scheduleJob(JobType jobType, boolean immediate) {
        Instant scheduleStartDate = immediate ? PeriodicEventUploaderScheduler.getImmediateScheduleStartDate() : PeriodicEventUploaderScheduler.getScheduleStartDate();
        switch (jobType.ordinal()) {
            case 0: {
                LOG.debug("Scheduled job to check analytics options configuration to start at {} and repeat every day", (Object)scheduleStartDate);
                this.scheduleJob(AnalyticsConfigStateRunner.JobId, AnalyticsConfigStateRunner.JobRunnerKey, scheduleStartDate);
                break;
            }
            case 1: {
                if (immediate) {
                    LOG.debug("Scheduled job to perform initial remote filter read to start at {}", (Object)scheduleStartDate);
                } else {
                    LOG.debug("Scheduled job to read remote event filters to start at {} and repeat every day", (Object)scheduleStartDate);
                }
                this.scheduleJob(RemoteFilterReadRunner.JobId, RemoteFilterReadRunner.JobRunnerKey, scheduleStartDate);
                break;
            }
            case 2: {
                LOG.debug("Scheduled job to upload analytics logs to start at {} and repeat every day", (Object)scheduleStartDate);
                this.scheduleJob(S3EventUploadRunner.JobId, S3EventUploadRunner.JobRunnerKey, scheduleStartDate);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown job type: " + String.valueOf((Object)jobType));
            }
        }
    }

    private void scheduleJob(JobId jobId, JobRunnerKey jobRunnerKey, Instant scheduleStartDate) {
        this.schedulerService.unscheduleJob(jobId);
        if (this.schedulerService.getJobDetails(jobId) == null) {
            Schedule schedule = Schedule.forInterval((long)PeriodicEventUploaderScheduler.getSchedulerInterval(), (Date)Date.from(scheduleStartDate));
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(schedule).withRunMode(RunMode.RUN_LOCALLY);
            try {
                this.schedulerService.scheduleJob(jobId, jobConfig);
            }
            catch (SchedulerServiceException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void runJob(JobType jobType) {
        this.scheduleJob(jobType, true);
    }

    public void scheduleJob(JobType jobType) {
        this.scheduleJob(jobType, false);
    }

    private static Instant getImmediateScheduleStartDate() {
        return Instant.now().plus(10L, ChronoUnit.SECONDS);
    }

    private static Instant getScheduleStartDate() {
        return UploadDateCalculator.calculateUploadTime(Instant.now());
    }

    private static long getSchedulerInterval() {
        return 172800000L;
    }

    public void unscheduleJobs() {
        this.schedulerService.unscheduleJob(AnalyticsConfigStateRunner.JobId);
        this.schedulerService.unscheduleJob(RemoteFilterReadRunner.JobId);
        this.schedulerService.unscheduleJob(S3EventUploadRunner.JobId);
    }

    public static enum JobType {
        ANALYTICS_CONFIG_STATE,
        REMOTE_FILTER_READ,
        S3_EVENT_UPLOAD;

    }
}

