/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest;

import com.atlassian.business.insights.api.dataset.Dataset;
import com.atlassian.business.insights.api.dataset.DatasetProvider;
import com.atlassian.business.insights.api.schema.SchemaStatus;
import com.atlassian.business.insights.core.analytics.path.CustomExportPathDeleteTriggeredAnalyticEvent;
import com.atlassian.business.insights.core.analytics.path.CustomExportPathGetRequestedAnalyticEvent;
import com.atlassian.business.insights.core.analytics.path.CustomExportPathUpdateFailedAnalyticEvent;
import com.atlassian.business.insights.core.analytics.path.CustomExportPathUpdateTriggeredAnalyticEvent;
import com.atlassian.business.insights.core.analytics.schedule.ExportScheduleDeleteTriggeredAnalyticEvent;
import com.atlassian.business.insights.core.analytics.schedule.ExportScheduleDeletedAnalyticEvent;
import com.atlassian.business.insights.core.analytics.schedule.ExportScheduleGetRequestedAnalyticEvent;
import com.atlassian.business.insights.core.analytics.schedule.ExportScheduleUpdateAnalyticEvent;
import com.atlassian.business.insights.core.analytics.schedule.ExportScheduleUpdateTriggeredAnalyticEvent;
import com.atlassian.business.insights.core.analytics.schema.SupportedSchemaVersionsGetRequestedAnalyticEvent;
import com.atlassian.business.insights.core.rest.exception.InvalidRequestBodyException;
import com.atlassian.business.insights.core.rest.model.ConfigExportPathRequest;
import com.atlassian.business.insights.core.rest.model.ConfigExportPathResponse;
import com.atlassian.business.insights.core.rest.model.ConfigExportScheduleRequest;
import com.atlassian.business.insights.core.rest.model.ConfigExportScheduleResponse;
import com.atlassian.business.insights.core.rest.model.ErrorStatusResponse;
import com.atlassian.business.insights.core.rest.model.SchemaResponse;
import com.atlassian.business.insights.core.rest.validation.ValidationResult;
import com.atlassian.business.insights.core.rest.validation.validators.RequestValidator;
import com.atlassian.business.insights.core.rest.validation.validators.requestbody.annotation.PathRequestValidationNameBinding;
import com.atlassian.business.insights.core.rest.validation.validators.requestbody.annotation.ScheduleRequestValidationNameBinding;
import com.atlassian.business.insights.core.rest.validation.validators.util.SchemaVersionValueParser;
import com.atlassian.business.insights.core.service.ExportPathHolder;
import com.atlassian.business.insights.core.service.api.ConfigService;
import com.atlassian.business.insights.core.service.api.EventPublisherService;
import com.atlassian.business.insights.core.service.api.ExportScheduleService;
import com.atlassian.business.insights.core.service.api.ScheduleConfigService;
import com.atlassian.business.insights.core.service.scheduler.ScheduleConfig;
import com.atlassian.business.insights.core.util.DateConversionUtil;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.scheduler.status.JobDetails;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.nio.file.NotDirectoryException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.OrderComparator;

@OpenAPIDefinition(info=@Info(title="Data Pipeline Config Resource", version="1.0", description="Experimental Data Pipeline API. Configure Data Pipeline settings. The root path is /rest/datapipeline/latest"))
@Path(value="/config")
@SystemAdminOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfigResource {
    private final ConfigService configService;
    private final EventPublisherService eventPublisherService;
    private final ScheduleConfigService scheduleConfigService;
    private final ExportScheduleService exportScheduleService;
    private final TimeZoneManager timeZoneManager;
    private final DatasetProvider datasetProvider;
    private final RequestValidator requestValidator;

    @Inject
    public ConfigResource(ConfigService configService, ScheduleConfigService scheduleConfigService, EventPublisherService eventPublisherService, ExportScheduleService exportScheduleService, TimeZoneManager timeZoneManager, DatasetProvider datasetProvider, RequestValidator requestValidator) {
        this.configService = configService;
        this.scheduleConfigService = scheduleConfigService;
        this.eventPublisherService = eventPublisherService;
        this.exportScheduleService = exportScheduleService;
        this.timeZoneManager = timeZoneManager;
        this.datasetProvider = datasetProvider;
        this.requestValidator = requestValidator;
    }

    @Operation(summary="Creates or updates custom export root path", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the details of the updated export path.", content={@Content(schema=@Schema(implementation=ConfigExportPathRequest.class))}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @PUT
    @Path(value="/export-path")
    @PathRequestValidationNameBinding
    public Response updateExportPath(@RequestBody ConfigExportPathRequest configExportPathRequest, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "updateExportPath", uriInfo);
        this.publishCustomExportPathUpdateTriggeredAnalyticEvent();
        try {
            this.configService.setCustomExportPath(configExportPathRequest.getPath());
        }
        catch (NotDirectoryException e) {
            this.publishCustomExportPathUpdateFailedAnalyticEvent();
            throw new InvalidRequestBodyException(new ValidationResult("data-pipeline.api.rest.config.error.invalid.root.directory.path"));
        }
        return this.getExportPathResponse();
    }

    @Operation(summary="Deletes custom export path and reverts to the default export path", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the details of the updated export path.", content={@Content(schema=@Schema(implementation=ConfigExportPathRequest.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @DELETE
    @Path(value="/export-path")
    public Response deleteExportPath(@Context UriInfo uriInfo) throws NotDirectoryException {
        this.requestValidator.isValid(this.getClass(), "deleteExportPath", uriInfo);
        this.publishCustomExportPathDeleteTriggeredAnalyticEvent();
        this.configService.setCustomExportPath(null);
        return this.getExportPathResponse();
    }

    @Operation(summary="Retrieves the current export root path", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the details of the updated export path.", content={@Content(schema=@Schema(implementation=ConfigExportPathRequest.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @GET
    @Path(value="/export-path")
    public Response getExportPath(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "getExportPath", uriInfo);
        this.publishCustomExportPathGetRequestedAnalyticEvent();
        return this.getExportPathResponse();
    }

    @Operation(summary="Get supported schema versions", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns list of supported schema versions in descending order.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SchemaResponse.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @GET
    @Path(value="/schema")
    public Response getSupportedSchemaVersions(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "getSupportedSchemaVersions", uriInfo);
        this.publishSupportedSchemaVersionsGetRequestedAnalyticEvent();
        List schemaResponses = this.datasetProvider.getAllDatasets().stream().sorted(new OrderComparator().reversed()).map(SchemaResponse::fromDataset).collect(Collectors.toList());
        return Response.status((Response.Status)Response.Status.OK).entity(schemaResponses).build();
    }

    @Operation(summary="Creates or updates current export schedule setting", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Successfully received request to create schedule with provided settings."), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @PUT
    @Path(value="/schedule")
    @ScheduleRequestValidationNameBinding
    public Response updateExportSchedule(@RequestBody ConfigExportScheduleRequest configRequest, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "updateExportSchedule", uriInfo);
        ZoneId zoneId = this.getProductDefaultTimeZoneId();
        Dataset dataset = Optional.ofNullable(configRequest.getSchemaVersion()).map(this::toDataset).orElseGet(() -> ((DatasetProvider)this.datasetProvider).getDefaultDataset());
        ScheduleConfig.Builder scheduleConfigBuilder = new ScheduleConfig.Builder().from(configRequest).schemaVersion(dataset.getVersion()).zoneId(zoneId);
        this.publishScheduleUpdateTriggeredAnalyticEvent(scheduleConfigBuilder.build());
        JobDetails jobDetails = this.exportScheduleService.scheduleJob(scheduleConfigBuilder.build());
        Date scheduledStartDate = Optional.ofNullable(jobDetails.getNextRunTime()).orElseThrow(() -> new RuntimeException("Could not calculate schedule starting date!"));
        ScheduleConfig scheduleConfigWithStartDate = scheduleConfigBuilder.scheduleStartDate(DateConversionUtil.formatToIso(scheduledStartDate.toInstant(), zoneId)).build();
        this.scheduleConfigService.setExportSchedule(scheduleConfigWithStartDate);
        this.publishScheduleUpdatedAnalyticEvent(scheduleConfigWithStartDate);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @Operation(summary="Deletes export schedule", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully deleted schedule if there is one set."), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @DELETE
    @Path(value="/schedule")
    public Response deleteExportSchedule(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "deleteExportSchedule", uriInfo);
        this.publishScheduleDeleteTriggeredAnalyticEvent();
        this.scheduleConfigService.setExportSchedule(null);
        this.exportScheduleService.unscheduleJob();
        this.publishScheduleDeletedAnalyticEvent();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Retrieves the current export schedule setting", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the settings of the current export schedule if there is one set, otherwise, it will return an empty response", content={@Content(schema=@Schema(implementation=ConfigExportScheduleResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @GET
    @Path(value="/schedule")
    public Response getExportSchedule(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "getExportSchedule", uriInfo);
        this.publishScheduleGetRequestedAnalyticEvent();
        Optional<ScheduleConfig> scheduleConfig = this.scheduleConfigService.getExportSchedule();
        if (scheduleConfig.isPresent()) {
            String nextRunTime = this.scheduleConfigService.getNextRunTime().map(date -> DateConversionUtil.formatToIso(date.toInstant(), ZoneId.of(((ScheduleConfig)scheduleConfig.get()).getZoneId()))).orElse(null);
            SchemaStatus schemaStatus = this.datasetProvider.getSchemaStatus(scheduleConfig.get().getSchemaVersion());
            ConfigExportScheduleResponse configExportScheduleResponse = ConfigExportScheduleResponse.from(scheduleConfig.get(), schemaStatus, nextRunTime);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)configExportScheduleResponse).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(Collections.emptyMap()).build();
    }

    private ZoneId getProductDefaultTimeZoneId() {
        return this.timeZoneManager.getDefaultTimeZone().toZoneId();
    }

    private Response getExportPathResponse() {
        ExportPathHolder exportPath = this.configService.getRootExportPathHolder();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ConfigExportPathResponse.from(exportPath)).build();
    }

    private void publishCustomExportPathUpdateTriggeredAnalyticEvent() {
        this.eventPublisherService.publish(new CustomExportPathUpdateTriggeredAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishCustomExportPathUpdateFailedAnalyticEvent() {
        this.eventPublisherService.publish(new CustomExportPathUpdateFailedAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishCustomExportPathDeleteTriggeredAnalyticEvent() {
        this.eventPublisherService.publish(new CustomExportPathDeleteTriggeredAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishCustomExportPathGetRequestedAnalyticEvent() {
        this.eventPublisherService.publish(new CustomExportPathGetRequestedAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishSupportedSchemaVersionsGetRequestedAnalyticEvent() {
        this.eventPublisherService.publish(new SupportedSchemaVersionsGetRequestedAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishScheduleUpdateTriggeredAnalyticEvent(ScheduleConfig scheduleConfig) {
        this.eventPublisherService.publish(new ExportScheduleUpdateTriggeredAnalyticEvent(this.eventPublisherService.getPluginVersion(), scheduleConfig));
    }

    private void publishScheduleUpdatedAnalyticEvent(ScheduleConfig scheduleConfigWithStartDate) {
        this.eventPublisherService.publish(new ExportScheduleUpdateAnalyticEvent(this.eventPublisherService.getPluginVersion(), scheduleConfigWithStartDate));
    }

    private void publishScheduleDeleteTriggeredAnalyticEvent() {
        this.eventPublisherService.publish(new ExportScheduleDeleteTriggeredAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishScheduleDeletedAnalyticEvent() {
        this.eventPublisherService.publish(new ExportScheduleDeletedAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishScheduleGetRequestedAnalyticEvent() {
        this.eventPublisherService.publish(new ExportScheduleGetRequestedAnalyticEvent(this.eventPublisherService.getPluginVersion()));
    }

    private Dataset toDataset(String schemaVersion) {
        return (Dataset)SchemaVersionValueParser.parse(schemaVersion).flatMap(arg_0 -> ((DatasetProvider)this.datasetProvider).getDataset(arg_0)).orElseThrow(() -> new InvalidRequestBodyException(new ValidationResult("data-pipeline.api.rest.request.body.config.schema.version.invalid")));
    }
}

