/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest;

import com.atlassian.business.insights.api.filter.OptOutEntity;
import com.atlassian.business.insights.api.filter.OptOutEntityType;
import com.atlassian.business.insights.core.rest.model.ErrorStatusResponse;
import com.atlassian.business.insights.core.rest.model.OptOutConfigurationRequest;
import com.atlassian.business.insights.core.rest.model.OptOutConfigurationResponse;
import com.atlassian.business.insights.core.rest.model.OptOutEntityResponse;
import com.atlassian.business.insights.core.rest.model.OptOutEntitySummaryResponse;
import com.atlassian.business.insights.core.rest.validation.validators.RequestValidator;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.ContinueIfNotFoundValidator;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.Validator;
import com.atlassian.business.insights.core.service.api.EntityOptOutService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.message.I18nResolver;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@OpenAPIDefinition(info=@Info(title="Data Pipeline Opt-Out Resource", version="1.0", description="Experimental Data Pipeline API. Configure Data Pipeline opt-out settings. The root path is /rest/datapipeline/latest"))
@Path(value="/config/optout")
@SystemAdminOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OptOutEntityRestResource {
    private static final String INVALID_RES_TYPE_I18N_KEY = "data-pipeline.api.rest.config.optout.request.body.resource.type.invalid";
    private static final String RES_NOT_FOUND_I18N_KEY = "data-pipeline.api.rest.config.optout.request.body.resource.not.found";
    private final EntityOptOutService entityOptOutService;
    private final I18nResolver i18nResolver;
    private final RequestValidator requestValidator;

    @Inject
    public OptOutEntityRestResource(EntityOptOutService entityOptOutService, I18nResolver i18nResolver, RequestValidator requestValidator) {
        this.entityOptOutService = entityOptOutService;
        this.i18nResolver = i18nResolver;
        this.requestValidator = requestValidator;
    }

    @Operation(summary="List all opt-out entities", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns all the opt-out entities that have been added.", content={@Content(schema=@Schema(implementation=OptOutEntitySummaryResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @GET
    public Response getOptOutEntities(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "getOptOutEntities", uriInfo);
        return Response.ok().entity((Object)new OptOutEntitySummaryResponse(this.mapOptOutEntityResponses(this.entityOptOutService.getOptOutEntities()))).build();
    }

    @Operation(summary="Add opt-out entities.", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the opt-out entities that have been added.", content={@Content(schema=@Schema(implementation=OptOutConfigurationResponse.class))}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @POST
    public Response addOptOutEntities(@Parameter(description="Continue if one or more are resources not found.") @DefaultValue(value="false") @Schema(type="boolean") @QueryParam(value="continueIfNotFound") @Validator(value=ContinueIfNotFoundValidator.class) boolean continueIfNotFound, @RequestBody @Parameter(required=true) OptOutConfigurationRequest optOutConfigurationRequest, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "addOptOutEntities", uriInfo);
        this.validateSupportedEntityType(optOutConfigurationRequest);
        ArrayList<OptOutEntity> notFoundEntityHolder = new ArrayList<OptOutEntity>();
        List<OptOutEntity> optOutEntities = this.mapOptOutEntities(continueIfNotFound, optOutConfigurationRequest, notFoundEntityHolder);
        this.entityOptOutService.addEntityOptOuts(optOutEntities.stream().map(OptOutEntity::getIdentifier).collect(Collectors.toList()));
        return Response.ok().entity((Object)new OptOutConfigurationResponse(this.mapOptOutEntityResponses(optOutEntities), notFoundEntityHolder.isEmpty() ? null : this.mapOptOutEntityResponses(notFoundEntityHolder))).build();
    }

    @Operation(summary="Remove opt-out entities.", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the opt-out entities that have been deleted.", content={@Content(schema=@Schema(implementation=OptOutConfigurationResponse.class))}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @DELETE
    public Response removeOptOutEntities(@Parameter(description="Continue if one or more entities are not found.") @DefaultValue(value="true") @Schema(type="boolean") @QueryParam(value="continueIfNotFound") @Validator(value=ContinueIfNotFoundValidator.class) boolean continueIfNotFound, @RequestBody @Parameter(required=true) OptOutConfigurationRequest optOutConfigurationRequest, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "removeOptOutEntities", uriInfo);
        this.validateSupportedEntityType(optOutConfigurationRequest);
        ArrayList<OptOutEntity> notFoundEntityHolder = new ArrayList<OptOutEntity>();
        List<OptOutEntity> optOutEntities = this.mapOptOutEntities(continueIfNotFound, optOutConfigurationRequest, notFoundEntityHolder);
        optOutEntities.addAll(notFoundEntityHolder);
        this.entityOptOutService.removeEntityOptOuts(optOutEntities.stream().map(OptOutEntity::getIdentifier).collect(Collectors.toList()));
        return Response.ok().entity((Object)new OptOutConfigurationResponse(this.mapOptOutEntityResponses(optOutEntities), null)).build();
    }

    private void validateSupportedEntityType(OptOutConfigurationRequest optOutConfigurationRequest) throws WebApplicationException {
        Optional<OptOutEntityType> optOutEntityType = this.mapOptOutEntityType(optOutConfigurationRequest.getType());
        if (!optOutEntityType.isPresent() || !this.entityOptOutService.getSupportedEntityTypes().contains(optOutEntityType.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorStatusResponse(Response.Status.BAD_REQUEST.getStatusCode(), this.i18nResolver.getText(INVALID_RES_TYPE_I18N_KEY, new Serializable[]{optOutConfigurationRequest.getType(), this.getSupportedEntityTypeAsString()}), null, Instant.now().toString())).build());
        }
    }

    private List<OptOutEntity> mapOptOutEntities(boolean continueIfNotFound, OptOutConfigurationRequest optOutConfigurationRequest, List<OptOutEntity> notFoundEntityHolder) {
        return optOutConfigurationRequest.getKeys().stream().map(key -> this.mapOptOutEntity(optOutConfigurationRequest.getType(), (String)key, continueIfNotFound, notFoundEntityHolder)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<OptOutEntity> mapOptOutEntity(String entityType, String entityKey, boolean continueIfNotFound, List<OptOutEntity> notFoundEntityHolder) {
        return this.mapOptOutEntityType(entityType).map(optOutEntityType -> {
            Optional<OptOutEntity> optOutEntity = this.entityOptOutService.enrichOptOutEntity((OptOutEntityType)optOutEntityType, entityKey);
            if (!optOutEntity.isPresent()) {
                if (continueIfNotFound) {
                    notFoundEntityHolder.add(OptOutEntity.builder((OptOutEntityType)optOutEntityType, (String)entityKey).build());
                } else {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorStatusResponse(Response.Status.BAD_REQUEST.getStatusCode(), this.i18nResolver.getText(RES_NOT_FOUND_I18N_KEY, new Serializable[]{entityType, entityKey}), null, Instant.now().toString())).build());
                }
            }
            return optOutEntity;
        }).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorStatusResponse(Response.Status.BAD_REQUEST.getStatusCode(), this.i18nResolver.getText(INVALID_RES_TYPE_I18N_KEY, new Serializable[]{entityType, this.getSupportedEntityTypeAsString()}), null, Instant.now().toString())).build()));
    }

    private String getSupportedEntityTypeAsString() {
        return this.entityOptOutService.getSupportedEntityTypes().stream().map(Enum::toString).collect(Collectors.joining(",", "[", "]"));
    }

    private Optional<OptOutEntityType> mapOptOutEntityType(String type) {
        return Arrays.stream(OptOutEntityType.values()).filter(optOutEntityType -> optOutEntityType.toString().equalsIgnoreCase(type)).findFirst();
    }

    private List<OptOutEntityResponse> mapOptOutEntityResponses(List<OptOutEntity> optOutEntities) {
        return optOutEntities.stream().map(this::mapOptOutEntityResponse).collect(Collectors.toList());
    }

    private OptOutEntityResponse mapOptOutEntityResponse(OptOutEntity optOutEntity) {
        return new OptOutEntityResponse(optOutEntity.getIdentifier().getType().toString(), optOutEntity.getIdentifier().getIdentifier(), optOutEntity.getKey(), optOutEntity.getDisplayName(), optOutEntity.getUri());
    }
}

