/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest.exception.mapper;

import com.atlassian.business.insights.core.rest.exception.BadRequestException;
import com.atlassian.business.insights.core.rest.exception.mapper.DiagnosticDescriptionTranslator;
import com.atlassian.business.insights.core.rest.model.ErrorStatusResponse;
import com.atlassian.business.insights.core.rest.validation.DiagnosticDescription;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.time.Instant;
import java.util.List;

@Provider
@Priority(value=5000)
public class BadRequestExceptionMapper
implements ExceptionMapper<BadRequestException> {
    private final DiagnosticDescriptionTranslator descriptionTranslator;

    @Inject
    public BadRequestExceptionMapper(DiagnosticDescriptionTranslator descriptionTranslator) {
        this.descriptionTranslator = descriptionTranslator;
    }

    public Response toResponse(BadRequestException e) {
        List<DiagnosticDescription> translatedErrors = this.descriptionTranslator.translateValidationErrors(e.getValidationResult().getErrors());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorStatusResponse(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), translatedErrors, Instant.now().toString())).build();
    }
}

