/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest.validation.validators.requestbody;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.business.insights.core.rest.exception.InvalidRequestBodyException;
import com.atlassian.business.insights.core.rest.model.ConfigExportPathRequest;
import com.atlassian.business.insights.core.rest.validation.ValidationResult;
import com.atlassian.business.insights.core.rest.validation.validators.requestbody.annotation.PathRequestValidationNameBinding;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@Provider
@Priority(value=1000)
@PathRequestValidationNameBinding
public class PathRequestValidationInterceptor
implements ReaderInterceptor {
    @VisibleForTesting
    public static final String INVALID_DIRECTORY_KEY = "data-pipeline.api.rest.config.error.invalid.root.directory.path";
    @VisibleForTesting
    public static final String INVALID_REQUEST_BODY_KEY = "data-pipeline.api.rest.config.request.body.export.path.invalid";
    @VisibleForTesting
    public static final String REQUIRED_REQUEST_BODY_KEY = "data-pipeline.api.rest.config.request.body.export.path.required";
    @VisibleForTesting
    public static final String REQUIRED_REQUEST_BODY_PATH_LOCATION_KEY = "data-pipeline.api.rest.config.request.body.export.path.location.required";
    @VisibleForTesting
    public static final String INVALID_EXPORT_PATH_SHOULD_BE_ABSOLUTE_KEY = "data-pipeline.api.rest.config.request.body.export.path.should.be.absolute";

    public Object aroundReadFrom(ReaderInterceptorContext context) throws WebApplicationException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String content = null;
        ValidationResult validationResult = new ValidationResult();
        try {
            content = IOUtils.toString((InputStream)context.getInputStream(), (Charset)StandardCharsets.UTF_8);
            ConfigExportPathRequest exportPathRequest = (ConfigExportPathRequest)mapper.readValue(content, ConfigExportPathRequest.class);
            if (exportPathRequest.getPath() == null) {
                validationResult.add(REQUIRED_REQUEST_BODY_KEY);
            }
            this.validateExportPathLocation(validationResult, exportPathRequest);
        }
        catch (InvalidPathException e) {
            validationResult.add(INVALID_DIRECTORY_KEY);
        }
        catch (Exception e) {
            validationResult.add(INVALID_REQUEST_BODY_KEY);
        }
        if (validationResult.hasErrors()) {
            throw new InvalidRequestBodyException(validationResult);
        }
        context.setInputStream((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        return context.proceed();
    }

    private void validateExportPathLocation(ValidationResult validationResult, ConfigExportPathRequest exportPathRequest) {
        if (StringUtils.isBlank((CharSequence)exportPathRequest.getPath())) {
            validationResult.add(REQUIRED_REQUEST_BODY_PATH_LOCATION_KEY);
        } else if (this.isRelativePath(exportPathRequest) && !exportPathRequest.getPath().contains("\\")) {
            validationResult.add(INVALID_EXPORT_PATH_SHOULD_BE_ABSOLUTE_KEY);
        }
    }

    private boolean isRelativePath(ConfigExportPathRequest exportPathRequest) throws InvalidPathException {
        return !Paths.get(exportPathRequest.getPath(), new String[0]).isAbsolute();
    }
}

