/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest.validation.validators.requestbody;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.business.insights.core.rest.exception.InvalidDayException;
import com.atlassian.business.insights.core.rest.exception.InvalidRequestBodyException;
import com.atlassian.business.insights.core.rest.model.ConfigExportScheduleRequest;
import com.atlassian.business.insights.core.rest.validation.ValidationResult;
import com.atlassian.business.insights.core.rest.validation.validators.requestbody.annotation.ScheduleRequestValidationNameBinding;
import com.atlassian.business.insights.core.rest.validation.validators.util.ExportFromParser;
import com.atlassian.business.insights.core.rest.validation.validators.util.SchemaVersionValueParser;
import com.atlassian.business.insights.core.util.DateConversionUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@Provider
@Priority(value=1000)
@ScheduleRequestValidationNameBinding
public class ScheduleRequestValidationInterceptor
implements ReaderInterceptor {
    public static final String BAD_REQUEST_INVALID_SCHEMA_VERSION_KEY = "data-pipeline.api.rest.request.body.config.schema.version.invalid";
    public static final String BAD_REQUEST_INVALID_EXPORT_DAYS_OF_WEEK_KEY = "data-pipeline.api.rest.request.body.config.days.of.week.invalid";
    @VisibleForTesting
    static final String BAD_REQUEST_INVALID_FROM_DATE_KEY = "data-pipeline.api.rest.config.request.body.fromdate.invalid";
    @VisibleForTesting
    static final String BAD_REQUEST_FUTURE_FROM_DATE_KEY = "data-pipeline.api.rest.config.request.body.fromdate.not.be.future";
    @VisibleForTesting
    static final String BAD_REQUEST_INVALID_REQUEST_BODY_KEY = "data-pipeline.api.rest.request.body.config.schedule.invalid";
    @VisibleForTesting
    static final String BAD_REQUEST_INVALID_EXPORT_TIME_KEY = "data-pipeline.api.rest.request.body.config.time.invalid";
    @VisibleForTesting
    static final String BAD_REQUEST_INVALID_REPEAT_INTERVAL_IN_WEEKS_KEY = "data-pipeline.api.rest.request.body.config.repeat.interval.in.weeks.invalid";
    private static final int REPEAT_EVERY_LIMIT = 52;

    public Object aroundReadFrom(ReaderInterceptorContext context) throws WebApplicationException, IOException {
        ConfigExportScheduleRequest scheduleRequest = null;
        String content = null;
        ObjectMapper mapper = new ObjectMapper();
        ValidationResult validationResult = new ValidationResult();
        try {
            content = IOUtils.toString((InputStream)context.getInputStream(), (Charset)StandardCharsets.UTF_8);
            scheduleRequest = (ConfigExportScheduleRequest)mapper.readValue(content, ConfigExportScheduleRequest.class);
        }
        catch (Exception e) {
            this.handleException(e, validationResult);
        }
        Optional<Instant> exportFrom = ExportFromParser.parse(scheduleRequest.getFromDate());
        if (exportFrom.isPresent()) {
            if (exportFrom.get().isAfter(Instant.now())) {
                validationResult.add(BAD_REQUEST_FUTURE_FROM_DATE_KEY);
            }
        } else {
            validationResult.add(BAD_REQUEST_INVALID_FROM_DATE_KEY);
        }
        if (CollectionUtils.isEmpty(scheduleRequest.getDays())) {
            validationResult.add(BAD_REQUEST_INVALID_EXPORT_DAYS_OF_WEEK_KEY);
        }
        if (!this.isTimeValid(scheduleRequest.getTime())) {
            validationResult.add(BAD_REQUEST_INVALID_EXPORT_TIME_KEY);
        }
        if (!this.isRepeatIntervalInWeeksValid(scheduleRequest.getRepeatIntervalInWeeks())) {
            validationResult.add(BAD_REQUEST_INVALID_REPEAT_INTERVAL_IN_WEEKS_KEY);
        }
        if (scheduleRequest.getSchemaVersion() != null && SchemaVersionValueParser.isNotParsable(scheduleRequest.getSchemaVersion())) {
            validationResult.add(BAD_REQUEST_INVALID_SCHEMA_VERSION_KEY);
        }
        if (validationResult.hasErrors()) {
            throw new InvalidRequestBodyException(validationResult);
        }
        context.setInputStream((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        return context.proceed();
    }

    private void handleException(Exception e, ValidationResult validationResult) {
        if (e.getCause() instanceof InvalidDayException) {
            this.handleInvalidDayException(e, validationResult);
        } else {
            this.handleInvalidRequestBodyException(validationResult);
        }
    }

    private void handleInvalidDayException(Exception e, ValidationResult validationResult) {
        validationResult.add(BAD_REQUEST_INVALID_EXPORT_DAYS_OF_WEEK_KEY);
        throw new InvalidDayException(e.getMessage());
    }

    private void handleInvalidRequestBodyException(ValidationResult validationResult) {
        validationResult.add(BAD_REQUEST_INVALID_REQUEST_BODY_KEY);
        throw new InvalidRequestBodyException(validationResult);
    }

    private boolean isTimeValid(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return false;
        }
        try {
            DateConversionUtil.parseTimeAsLocalTime(time);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isRepeatIntervalInWeeksValid(String repeatWeeksString) {
        if (StringUtils.isBlank((CharSequence)repeatWeeksString)) {
            return false;
        }
        try {
            int repeatWeeks = Integer.parseInt(repeatWeeksString);
            return repeatWeeks > 0 && repeatWeeks <= 52;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

