/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.writer.convert;

import com.atlassian.business.insights.core.writer.convert.ValueConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.regex.Matcher;

public class EmbeddedLineBreakValueConverter
implements ValueConverter {
    private static final String ALL_EOL_CHARS = "\\r\\n|\\r|\\n";
    private final String escapeChar;

    public EmbeddedLineBreakValueConverter(@Nonnull String escapeChar) {
        this.escapeChar = escapeChar;
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object value) {
        if (value instanceof String) {
            return ((String)value).replaceAll(ALL_EOL_CHARS, Matcher.quoteReplacement(this.escapeChar));
        }
        return value;
    }
}

