/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest.one.zero.model;

import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginCssResourceParams;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=true)
public class Resource {
    private final String url;
    private final ResourceType resourceType;
    private final String media;
    private final String key;
    private final String batchType;

    public Resource(@Nonnull PluginJsResource resource) {
        this(resource.getStaticUrl(UrlMode.RELATIVE), ResourceType.JAVASCRIPT, null, resource.getKey(), resource.getBatchType());
    }

    public Resource(@Nonnull PluginCssResource cssResource) {
        this(cssResource.getStaticUrl(UrlMode.RELATIVE), ResourceType.CSS, ((PluginCssResourceParams)cssResource.getParams()).media(), cssResource.getKey(), cssResource.getBatchType());
    }

    @Deprecated
    @JsonCreator
    public Resource(@Nonnull @JsonProperty(value="url") String url, @Nonnull @JsonProperty(value="resourceType") ResourceType resourceType, @Nullable @JsonProperty(value="media") String media, @Nonnull @JsonProperty(value="key") String key, @Nonnull @JsonProperty(value="batchType") PluginUrlResource.BatchType batchType) {
        this.url = url;
        this.resourceType = resourceType;
        this.media = media;
        this.key = key;
        this.batchType = batchType.name().toUpperCase();
    }

    @JsonProperty
    @Nonnull
    public PluginUrlResource.BatchType getBatchType() {
        return PluginUrlResource.BatchType.valueOf((String)this.batchType);
    }

    @JsonProperty
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    @Nonnull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @JsonProperty
    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public String getMedia() {
        return this.media;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Resource) {
            Resource otherResource = (Resource)other;
            return Objects.equals(this.url, otherResource.url) && Objects.equals((Object)this.resourceType, (Object)otherResource.resourceType) && Objects.equals(this.media, otherResource.media) && Objects.equals(this.key, otherResource.key) && Objects.equals(this.batchType, otherResource.batchType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.resourceType, this.media, this.key, this.batchType});
    }

    public String toString() {
        return "Resource{key='" + this.key + "', batchType='" + this.batchType + "', resourceType=" + String.valueOf((Object)this.resourceType) + ", media='" + this.media + "', url='" + this.url + "'}";
    }

    public static enum ResourceType {
        JAVASCRIPT,
        CSS;

    }
}

