/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest.two.zero.util;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.webresource.models.Requestable;
import com.atlassian.plugin.webresource.models.WebResourceContextKey;
import com.atlassian.plugin.webresource.models.WebResourceKey;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import com.atlassian.webresource.plugin.async.model.OutputShape;
import com.atlassian.webresource.plugin.async.model.ResourceTypeAndUrl;
import com.atlassian.webresource.plugin.rest.two.zero.model.ResourceType;
import com.atlassian.webresource.plugin.rest.two.zero.model.UrlFetchableResourceJson;
import com.atlassian.webresource.plugin.rest.two.zero.model.UrlFetchableResourcesWithDataJson;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class PhasesAwareResourcesModelMapperUtil {
    @VisibleForTesting
    public static final String WEB_RESOURCE_CONTEXT_PREFIX = "wrc!";
    private static final String WEB_RESOURCE_PREFIX = "wr!";

    private PhasesAwareResourcesModelMapperUtil() throws Exception {
        throw new Exception("Static util class is not meant to be instantiated");
    }

    public static <T extends Requestable> Map<ResourcePhase, Set<T>> byPhase(Set<T> require, Set<T> requireForInteraction) {
        HashMap<ResourcePhase, Set<T>> requestablesPerPhase = new HashMap<ResourcePhase, Set<T>>();
        requestablesPerPhase.put(ResourcePhase.REQUIRE, require);
        requestablesPerPhase.put(ResourcePhase.INTERACTION, requireForInteraction);
        return requestablesPerPhase;
    }

    public static UrlFetchableResourcesWithDataJson transformOutputShapeToUrlFetchableResourcesWithDataJson(@Nonnull OutputShape outputShape) {
        return new UrlFetchableResourcesWithDataJson(outputShape.getResources().stream().map(PhasesAwareResourcesModelMapperUtil::transformResourceTypeAndUrlToUrlFetchableResourceJson).collect(Collectors.toList()), outputShape.getUnparsedData(), outputShape.getUnparsedErrors());
    }

    private static UrlFetchableResourceJson transformResourceTypeAndUrlToUrlFetchableResourceJson(@Nonnull ResourceTypeAndUrl resourceTypeAndUrl) {
        return new UrlFetchableResourceJson(resourceTypeAndUrl.getBatchType(), resourceTypeAndUrl.getKey(), ResourceType.valueOf(resourceTypeAndUrl.getResourceType().name().toUpperCase()), resourceTypeAndUrl.getUrl());
    }

    public static <T extends Requestable> Set<T> transformStringsToRequestable(Collection<String> requestableStrings, String identifyingPrefix, Function<String, T> constructor) {
        return requestableStrings.stream().filter(requestableString -> requestableString.startsWith(identifyingPrefix)).map(requestableString -> requestableString.replaceFirst(identifyingPrefix, "")).filter(StringUtils::isNotBlank).map(constructor).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<WebResourceContextKey> transformStringsToFallbackRequestable(Collection<String> requestableStrings) {
        return requestableStrings.stream().filter(requestableString -> !requestableString.startsWith(WEB_RESOURCE_PREFIX) && !requestableString.startsWith(WEB_RESOURCE_CONTEXT_PREFIX)).filter(StringUtils::isNotBlank).map(WebResourceContextKey::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<WebResourceKey> transformStringsToWebResourceKeysSet(Collection<String> requestableStrings) {
        return PhasesAwareResourcesModelMapperUtil.transformStringsToRequestable(requestableStrings, WEB_RESOURCE_PREFIX, WebResourceKey::new);
    }

    public static Set<WebResourceContextKey> transformStringsToWebResourceContextKeysSet(Collection<String> requestableStrings) {
        Set<WebResourceContextKey> setOfWebResourceContextKeys = PhasesAwareResourcesModelMapperUtil.transformStringsToRequestable(requestableStrings, WEB_RESOURCE_CONTEXT_PREFIX, WebResourceContextKey::new);
        setOfWebResourceContextKeys.addAll(PhasesAwareResourcesModelMapperUtil.transformStringsToFallbackRequestable(requestableStrings));
        return setOfWebResourceContextKeys;
    }
}

