/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theme.filter;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.theme.internal.api.request.RequestScopeThemeOverrideService;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class DefaultRequestOverrideServletFilter
implements Filter {
    protected static final Logger log = LoggerFactory.getLogger(DefaultRequestOverrideServletFilter.class);
    @VisibleForTesting
    protected static final String THEME_SWITCHER_DARK_FEATURE_KEY = "theme.switcher";
    @VisibleForTesting
    protected static final String ATL_THEME_COLOR_MODE_OVERRIDE = "atlThemeColorMode";
    @VisibleForTesting
    protected static final String ATL_THEME_DARK_OVERRIDE = "atlThemeDark";
    @VisibleForTesting
    protected static final String ATL_THEME_LIGHT_OVERRIDE = "atlThemeLight";
    @VisibleForTesting
    protected static final String ATL_THEME_MATCH_UA_OVERRIDE = "atlThemeMatchUa";
    private final RequestScopeThemeOverrideService themeOverrideService;

    public DefaultRequestOverrideServletFilter(@Nonnull RequestScopeThemeOverrideService themeOverrideService) {
        this.themeOverrideService = Objects.requireNonNull(themeOverrideService, "themeOverrideService");
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest)) {
            log.debug("Unable to cast ServletRequest to HttpServletRequest and thus unable to apply theme overrides");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String colorModeOverride = request.getParameter(ATL_THEME_COLOR_MODE_OVERRIDE);
        String darkThemeOverride = request.getParameter(ATL_THEME_DARK_OVERRIDE);
        String lightThemeOverride = request.getParameter(ATL_THEME_LIGHT_OVERRIDE);
        String matchUserAgentOverride = request.getParameter(ATL_THEME_MATCH_UA_OVERRIDE);
        this.themeOverrideService.setColorModeOverride(httpServletRequest, colorModeOverride);
        this.themeOverrideService.setDarkThemeOverride(httpServletRequest, darkThemeOverride);
        this.themeOverrideService.setLightThemeOverride(httpServletRequest, lightThemeOverride);
        if (!Objects.isNull(matchUserAgentOverride) && !matchUserAgentOverride.trim().isEmpty()) {
            this.themeOverrideService.setMatchingUserAgentEnabledOverride(httpServletRequest, Boolean.valueOf(matchUserAgentOverride.trim()));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

