/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theme.user;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.internal.api.ThemeService;
import com.atlassian.theme.internal.api.user.PreferredColorMode;
import com.atlassian.theme.internal.api.user.UserThemeService;
import com.atlassian.theme.user.ErrorMessages;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@OpenAPIDefinition(info=@Info(title="Atlassian Theme", description="Cross-product theme REST API. The root path is /rest/atlassian-theme/1", version="1"), tags={@Tag(name="User Preferences", description="For accessing and modifying the user's preferences")})
@Path(value="user-preferences")
@Produces(value={"application/json"})
@LicensedOnly
public class PreferenceRestResource {
    private final ThemeService themeService;
    private final UserManager userManager;
    private final UserThemeService userThemeService;

    @Inject
    public PreferenceRestResource(@Nonnull ThemeService themeService, @Nonnull UserManager userManager, @Nonnull UserThemeService userThemeService) {
        this.themeService = Objects.requireNonNull(themeService, "themeService");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.userThemeService = Objects.requireNonNull(userThemeService, "userThemeService");
    }

    @Operation(summary="Get theme preferences for the user", description="Should NOT be used for rendering because it might not match the page! Can be used for theme switching and testing.", tags={"User Preferences"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UserThemePreferences.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(schema=@Schema(implementation=ErrorMessages.class))})})
    @GET
    public Response getUserThemePreferences() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (Objects.isNull(userKey)) {
            return Response.serverError().entity((Object)new ErrorMessages(Collections.singletonList("Couldn't find the user key"))).build();
        }
        UserThemePreferences userThemePreferences = new UserThemePreferences(this.userThemeService.getPreferredColorMode(userKey).map(Enum::toString).orElse(null), this.userThemeService.getPreferredDarkTheme(userKey).map(Theme::getThemeKey).orElse(null), this.userThemeService.getPreferredLightTheme(userKey).map(Theme::getThemeKey).orElse(null));
        return Response.ok().entity((Object)userThemePreferences).build();
    }

    @Operation(summary="Set theme preferences for the user", description="Updates individual preferences for the user with what is provided", tags={"User Preferences"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK - Everything was updated", content={@Content(schema=@Schema(implementation=UserThemePreferences.class))}), @ApiResponse(responseCode="400", description="Bad Request - Nothing was updated", content={@Content(schema=@Schema(implementation=ErrorMessages.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(schema=@Schema(implementation=ErrorMessages.class))})})
    @POST
    @Consumes(value={"application/json"})
    public Response setUserThemePreferences(@DefaultValue(value="{}") @Nullable UserThemePreferences userThemePreferences) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (Objects.isNull(userKey)) {
            return Response.serverError().entity((Object)new ErrorMessages(Collections.singletonList("Couldn't find the user key"))).build();
        }
        if (Objects.isNull(userThemePreferences)) {
            return Response.noContent().build();
        }
        ArrayList<String> errors = new ArrayList<String>();
        Optional<PreferredColorMode> matchingColorMode = Arrays.stream(PreferredColorMode.values()).filter(validColorMode -> validColorMode.toString().equals(userThemePreferences.colorMode)).findAny();
        if (PreferenceRestResource.isNotBlank(userThemePreferences.colorMode) && !matchingColorMode.isPresent()) {
            errors.add("No preferred color mode matches, valid options are: " + Arrays.toString(PreferredColorMode.values()));
        }
        Optional matchingDarkTheme = this.themeService.findMatchingTheme(ThemeColorMode.DARK, userThemePreferences.darkThemeKey);
        if (PreferenceRestResource.isNotBlank(userThemePreferences.darkThemeKey) && !matchingDarkTheme.isPresent()) {
            errors.add("No dark theme available with the key '" + userThemePreferences.darkThemeKey + "'");
        }
        Optional matchingLightTheme = this.themeService.findMatchingTheme(ThemeColorMode.LIGHT, userThemePreferences.lightThemeKey);
        if (PreferenceRestResource.isNotBlank(userThemePreferences.lightThemeKey) && !matchingLightTheme.isPresent()) {
            errors.add("No light theme available with the key '" + userThemePreferences.lightThemeKey + "'");
        }
        if (!errors.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessages(errors)).build();
        }
        matchingColorMode.ifPresent(colorMode -> this.userThemeService.setPreferredColorMode(userKey, colorMode));
        matchingDarkTheme.ifPresent(theme -> this.userThemeService.setPreferredDarkTheme(userKey, theme));
        matchingLightTheme.ifPresent(theme -> this.userThemeService.setPreferredLightTheme(userKey, theme));
        return Response.ok().build();
    }

    private static boolean isNotBlank(String potentiallyBlank) {
        return !Objects.isNull(potentiallyBlank) && !potentiallyBlank.trim().isEmpty();
    }

    @Schema(title="User theme preferences response")
    public static class UserThemePreferences {
        @Schema(name="Color mode", allowableValues={"MATCHING", "DARK", "LIGHT"}, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
        @Nullable
        public String colorMode;
        @Schema(name="Dark theme key", examples={"dark"}, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
        @Nullable
        public String darkThemeKey;
        @Schema(name="Light theme key", examples={"original", "light"}, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
        @Nullable
        public String lightThemeKey;

        public UserThemePreferences() {
        }

        public UserThemePreferences(@Nullable String colorMode, @Nullable String darkThemeKey, @Nullable String lightThemeKey) {
            this.colorMode = colorMode;
            this.darkThemeKey = darkThemeKey;
            this.lightThemeKey = lightThemeKey;
        }
    }
}

