/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web;

import com.atlassian.johnson.Initable;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.support.EventExceptionTranslator;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SpringEventType {
    public static final String PARAM_ADD_EVENT_ON_BYPASS = "johnson.spring.addEventOnBypass";
    public static final String PARAM_EVENT_TYPE = "johnson.spring.eventType";
    public static final String PARAM_EXCEPTION_TRANSLATOR_CLASS = "exceptionTranslatorClass";
    public static final String SEPARATORS = ",; \t\n";
    public static final String SPRING_CONTEXT_EVENT_TYPE = "spring";
    public static final String SPRING_SERVLET_EVENT_TYPE = "spring-mvc";
    private static final Logger LOG = LoggerFactory.getLogger(SpringEventType.class);

    private SpringEventType() {
        throw new UnsupportedOperationException(this.getClass().getName() + " should not be instantiated");
    }

    public static boolean addEventOnBypass(@Nonnull ServletContext context) {
        return "true".equals(Objects.requireNonNull(context, "context").getInitParameter(PARAM_ADD_EVENT_ON_BYPASS));
    }

    public static boolean addEventOnBypass(@Nonnull ServletConfig config) {
        String value = Objects.requireNonNull(config, "config").getInitParameter(PARAM_ADD_EVENT_ON_BYPASS);
        if (value == null) {
            return SpringEventType.addEventOnBypass(config.getServletContext());
        }
        return "true".equals(value);
    }

    @Nonnull
    public static Event createDefaultEvent(@Nonnull String eventType, @Nonnull String message, @Nonnull Throwable t) {
        return new Event(EventType.get((String)eventType), message, Event.toString((Throwable)t), EventLevel.get((String)"fatal"));
    }

    @Nonnull
    public static String getContextEventType(@Nonnull ServletContext context) {
        String value = Objects.requireNonNull(context, "context").getInitParameter(PARAM_EVENT_TYPE);
        if (!StringUtils.hasText((String)value)) {
            value = SPRING_CONTEXT_EVENT_TYPE;
        }
        return value;
    }

    @Nonnull
    public static String getServletEventType(@Nonnull ServletConfig config) {
        String value = Objects.requireNonNull(config, "config").getInitParameter(PARAM_EVENT_TYPE);
        if (!StringUtils.hasText((String)value)) {
            value = SPRING_SERVLET_EVENT_TYPE;
        }
        return value;
    }

    @Nullable
    public static Event translateThrowable(@Nonnull ServletConfig config, @Nonnull Throwable t) {
        return SpringEventType.translateThrowable(new ServletConfigMapSupplier(config), t);
    }

    @Nullable
    public static Event translateThrowable(@Nonnull ServletContext servletContext, @Nonnull Throwable t) {
        return SpringEventType.translateThrowable(new ServletContextMapSupplier(servletContext), t);
    }

    @Nullable
    private static Class<EventExceptionTranslator> loadTranslatorClass(@Nonnull String className) {
        try {
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
            if (EventExceptionTranslator.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            LOG.warn("Translator class {} does not implement {}", (Object)className, (Object)EventExceptionTranslator.class.getName());
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Translator class {} could not be loaded", (Object)className);
        }
        return null;
    }

    private static Event translateThrowable(@Nonnull MapSupplier supplier, @Nonnull Throwable t) {
        String param = supplier.getValue(PARAM_EXCEPTION_TRANSLATOR_CLASS);
        if (!StringUtils.hasText((String)param)) {
            return null;
        }
        ArrayList<Class<EventExceptionTranslator>> translatorClasses = new ArrayList<Class<EventExceptionTranslator>>();
        for (String className : StringUtils.tokenizeToStringArray((String)param, (String)SEPARATORS)) {
            Class<EventExceptionTranslator> clazz = SpringEventType.loadTranslatorClass(className);
            if (clazz == null) continue;
            translatorClasses.add(clazz);
        }
        if (translatorClasses.isEmpty()) {
            LOG.warn("None of the configured translator classes could be loaded");
            return null;
        }
        for (Class clazz : translatorClasses) {
            try {
                Event event;
                EventExceptionTranslator translator = (EventExceptionTranslator)BeanUtils.instantiateClass((Class)clazz, EventExceptionTranslator.class);
                if (translator instanceof Initable) {
                    ((Initable)translator).init(supplier.get());
                }
                if ((event = translator.translate(t)) == null) continue;
                return event;
            }
            catch (BeanInstantiationException e) {
                LOG.warn("{} could not be instantiated", (Object)clazz.getName(), (Object)e);
            }
        }
        return null;
    }

    private static class ServletConfigMapSupplier
    extends AbstractMapSupplier {
        private final ServletConfig config;

        private ServletConfigMapSupplier(ServletConfig config) {
            this.config = config;
        }

        @Override
        public String getValue(@Nonnull String name) {
            return this.config.getInitParameter(name);
        }

        @Override
        @Nonnull
        protected Enumeration<String> getNames() {
            return this.config.getInitParameterNames();
        }
    }

    private static interface MapSupplier {
        @Nonnull
        public Map<String, String> get();

        @Nullable
        public String getValue(@Nonnull String var1);
    }

    private static class ServletContextMapSupplier
    extends AbstractMapSupplier {
        private final ServletContext servletContext;

        private ServletContextMapSupplier(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        @Override
        public String getValue(@Nonnull String name) {
            return this.servletContext.getInitParameter(name);
        }

        @Override
        protected Enumeration<String> getNames() {
            return this.servletContext.getInitParameterNames();
        }
    }

    private static abstract class AbstractMapSupplier
    implements MapSupplier {
        private Map<String, String> map;

        private AbstractMapSupplier() {
        }

        @Override
        @Nonnull
        public Map<String, String> get() {
            if (this.map == null) {
                this.map = this.buildMap();
            }
            return this.map;
        }

        protected Map<String, String> buildMap() {
            ArrayList<String> names = Collections.list(this.getNames());
            if (names.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, String> map = new HashMap<String, String>(names.size(), 1.0f);
            for (String name : names) {
                map.put(name, this.getValue(name));
            }
            return Collections.unmodifiableMap(map);
        }

        protected abstract Enumeration<String> getNames();
    }
}

